public class ZahlenListe
{ private Knoten erster;
  
  public ZahlenListe()
  { erster = null;  }

  public void insert (int zahl)
  { Knoten lauf   = erster;
    Knoten vorher = null;
    while (lauf!=null && zahl>lauf.getWert()) 
    {  vorher = lauf;
       lauf   = lauf.getNachfolger();
    }
    // Einfuegestelle oder Listenende gefunden 
    Knoten neu = new Knoten(zahl, null);
    neu.setNachfolger(lauf);      // nach vorne "verknoten"
    if (lauf==erster)
         erster = neu;
    else vorher.setNachfolger(neu); // von hinten "verknoten"
  } // insert

  public void delete (int zahl)
  { Knoten lauf   = erster;
    Knoten vorher = null;
    while (lauf!=null && zahl!=lauf.getWert()) // kurze Auswertung
    {  vorher = lauf;
       lauf   = lauf.getNachfolger();
    }
    // Ende der Schleife, wenn zahl=lauf.getWert() oder lauf==null
    if (lauf!=null)
         if (lauf==erster)
              erster = lauf.getNachfolger();
         else vorher.setNachfolger(lauf.getNachfolger());
  } // delete

  public void gibAllesAus()
  { Knoten lauf = erster;
    if (lauf==null)
        { System.out.println("Liste ist leer.");
          return;
        }
    while (lauf!=null)
    {  System.out.print (lauf.getWert() + "  ");
       lauf = lauf.getNachfolger();
    }
    System.out.println();
  } // gibAllesAus
  
} // class ZahlenListe
