public abstract class Ereignisanwendung extends Anwendung
{
  // Attribute
  boolean zBeiDerArbeit;
  boolean zMausUnten;
  int zAltMausH, zAltMausV;

  public Ereignisanwendung()
  {  super();
     zBeiDerArbeit = false;
     zMausUnten = false;
  }

  public void fuehreAus()
  { zBeiDerArbeit = true;
    do // lausche auf Ereignisse
    {    // teste Mausdruck-Ereignis
       if (this.maus().istGedrueckt() && !zMausUnten)
       {  zMausUnten = true;
        this.bearbeiteMausDruck(this.maus().hPosition(), 
                                        this.maus().vPosition());
       }
       // teste Mauslos-Ereignis
       else if (!this.maus().istGedrueckt() && zMausUnten)
       {  zMausUnten = false;
        this.bearbeiteMausLos(this.maus().hPosition(), 
                                      this.maus().vPosition());
       }
       // teste Mausbewegt-Ereignis
       else if (this.maus().hPosition() != zAltMausH ||
                this.maus().vPosition() != zAltMausV)
       { this.bearbeiteMausBewegt(this.maus().hPosition(), 
                                        this.maus().vPosition());
        zAltMausH = this.maus().hPosition();
        zAltMausV = this.maus().vPosition();
       }
       // teste Doppelklick-Ereignis
       else if (this.maus().doppelKlick())
           this.bearbeiteDoppelKlick(this.maus().hPosition(),
                                     this.maus().vPosition());
       // teste Zeicheneingabe-Ereignis
       else if (this.tastatur().wurdeGedrueckt())
       {  this.bearbeiteTaste(this.tastatur().zeichen());
        this.tastatur().weiter();
       }
    }
    while (zBeiDerArbeit);
  }

  public void beenden()
  {
    zBeiDerArbeit = false;    
  }
  
  public abstract void bearbeiteMausDruck(int pWoH, int pWoV);

  public abstract void bearbeiteMausLos(int pWoH, int pWoV);

  public abstract void bearbeiteMausBewegt(int pWohinH, int pWohinV);

  public abstract void bearbeiteDoppelKlick(int pWoH, int pWoV);

  public abstract void bearbeiteTaste(char pZeichen);
}