import sum.kern.*;

public class Gummilinienanwendung extends Ereignisanwendung
{
	// Bezugsobjekte
	private Buntstift hatStift;

	// Attribute
	private int zAnkerH, zAnkerV, zZielH, zZielV;
	private boolean zMausUnten;

	// Konstruktor
	public Gummilinienanwendung()
	{
		super();
		hatStift = new Buntstift();
		zMausUnten = false;
	}

	public void bearbeiteMausDruck(int pWoH, int pWoV)
	{
		this.verankereLinie(pWoH, pWoV);
		zMausUnten = true;
	}

	public void bearbeiteMausLos(int pWoH, int pWoV)
	{
		hatStift.hoch();
		zMausUnten = false;
	}

	public void bearbeiteMausBewegt(int pWohinH, int pWohinV)
	{
		if (zMausUnten)
			this.verschiebeLinie(pWohinH, pWohinV);
	}

	public void bearbeiteDoppelKlick(int pWoH, int pWoV)
	{
	    beenden();
		this.gibFrei();
	}

	public void bearbeiteTaste(char pZeichen)
	{
		this.aendereFarbe(pZeichen);
	}

	private void verankereLinie(int pWoH, int pWoV)
	{
		zAnkerH = pWoH;
		zAnkerV = pWoV;
		zZielH = zAnkerH;
		zZielV = zAnkerV;
		hatStift.bewegeBis(zZielH, zZielV);
		hatStift.runter();
	}

	private void verschiebeLinie(int pWohinH, int pWohinV)
	{
		hatStift.radiere();
		hatStift.bewegeBis(zAnkerH, zAnkerV);
		hatStift.normal();
		hatStift.bewegeBis(pWohinH, pWohinV);
		zZielH = pWohinH;
		zZielV = pWohinV;
	}

	private void aendereFarbe(char pZeichen)
	{
		switch (pZeichen)
		{
			case 'R':
			case 'r':
				hatStift.setzeFarbe(Farbe.ROT);
				break;
			case 'G':
			case 'g':
				hatStift.setzeFarbe(Farbe.GRUEN);
				break;
			case 'B':
			case 'b':
				hatStift.setzeFarbe(Farbe.BLAU);
				break;
			case 'S':
			case 's':
				hatStift.setzeFarbe(Farbe.SCHWARZ);
				break;
		}
	}

	public void gibFrei()
	{
		hatStift.gibFrei();
		super.gibFrei();
	}
}