import sum.kern.*;
import sum.werkzeuge.*;

public class Wolf
{
    // Bezugsobjekte
    Rechner hatRechner;
    Buntstift hatStift;
    Bildschirm kenntBildschirm;
    Rotkaeppchen kenntRotkaeppchen;
    
    // Attribute
    double zAbstand;
    double zGeschwindigkeit;

    // Konstruktor
    public Wolf(double pGeschw, Bildschirm pBildschirm)
    {
        kenntBildschirm = pBildschirm;
        hatRechner      = new Rechner();
        hatStift        = new Buntstift();
        hatStift.bewegeBis(hatRechner.ganzeZufallszahl(10, kenntBildschirm.breite() - 10),
                           hatRechner.ganzeZufallszahl(10, kenntBildschirm.hoehe() - 10));
        hatStift.runter();
        hatStift.setzeFarbe(Farbe.SCHWARZ);
        zGeschwindigkeit = pGeschw;

    }

    public void lerneKennen(Rotkaeppchen rotkappe)
    {
      kenntRotkaeppchen = rotkappe;
      zAbstand = this.abstand();
    }

    public void gibFrei()
    {
        hatStift.gibFrei();
        hatRechner.gibFrei();
    }
    
    public void bewege()
    {
        hatStift.bewegeUm(zGeschwindigkeit);
        if (this.amLinkenRand())
             hatStift.dreheBis(0);
        else if (this.amRechtenRand())
             hatStift.dreheBis(180);
        else if (this.amOberenRand())
             hatStift.dreheBis(-90);
        else if (this.amUnterenRand())
             hatStift.dreheBis(90);       
        else hatStift.dreheUm(hatRechner.ganzeZufallszahl(-90, 90));
        zAbstand = this.abstand();
        
    }
    
    private boolean amLinkenRand()
    {  
       return hatStift.hPosition() < 10;
    }    
    
    private boolean amRechtenRand()
    {
       return hatStift.hPosition() > kenntBildschirm.breite() - 10;
    }    
    
    private boolean amOberenRand()
    {
       return hatStift.vPosition() < 10;
    }    
    
    private boolean amUnterenRand()
    {
       return hatStift.vPosition() > kenntBildschirm.hoehe() - 10;
    }

    public double hPosition()
    {
       return hatStift.hPosition();
    }

    public double vPosition()
    {
       return hatStift.vPosition();
    }
    
    public double abstand()
    {  double x_w, y_w,  // Wolfkoordinaten
              x_r, y_r,  // Rotkaeppchenkoordinaten
              d;         // Abstand mit Pythagoras berechnet
       x_w = hatStift.hPosition();
       y_w = hatStift.vPosition();
       x_r = kenntRotkaeppchen.hPosition();
       y_r = kenntRotkaeppchen.vPosition();
       d   = hatRechner.wurzel(hatRechner.quadrat(x_r - x_w) + hatRechner.quadrat(y_r - y_w));
       return d;
    }
}
