; Fibonacci-Zahlen rekursiv berechnen fuer DC
; Parameter, Zwischen- und Funktionsergebnis auf Stack
; Version mit BasePointer BP (ab Version 6.1)
            JMP Anfang
Null        DEF 000               ; CONST Null = 0
Eins        DEF 001               ;       Eins = 1
Zwei        DEF 002               ;       Zwei = 2
EndWert     DEF 005               ; VAR   EndWert,
K           DEF 000               ;       K,
FiboResult  DEF 000               ;       FiboResult : DCINTEGER;

            ; BEGIN (* Hauptprogramm *)
Anfang
            INM EndWert           ; Read (Endwert);
            LDA Eins
            STA K
WhileAnfang
            LDA K                 ; WHILE (K <= EndWert) DO BEGIN
            SUB EndWert
            JPL WhileEnde
            PSHM K                ;      Parameter K auf Stack
            JSR Fibo              ;      Aufruf
            POPM FiboResult       ;      FiboResult := Fibo (K)
            OUT FiboResult        ;      Write (FiboResult)
            LDA K
            INC
            STA K                 ;       K := K + 1;
            JMP WhileAnfang       ; END; (* WHILE *)
WhileEnde
            END                   ; End. (* Hauptprogramm *)

                                  ; (* -------------------------------- *)
Fibo                              ; FUNCTION Fibo (N : INTEGER) : INTEGER;
            N      EQUAL 3        ;        N        BP + 3
                                  ;        RSA      BP + 2
            Ablage EQUAL 1        ;        Ablage   BP + 1
                                  ; BEGIN
            PSH                   ; Platz fuer Ablage schaffen
            SPBP
            LDAB N
            JNZ Else1             ; IF N = 0 THEN
            LDA Null              ;      BEGIN
            STAB N                ;      Fibo := 0;
            JMP EndIf1            ;      END
Else1                             ; ELSE BEGIN
            LDAB N
            SUB Eins
            JNZ Else2             ;      IF (N = 1) THEN
            LDA Eins              ;           BEGIN
            STAB N                ;           Fibo := 1;
            JMP EndIf2            ;           END
Else2
            LDAB N                ;      ELSE BEGIN
            DEC                   ;           Berechne  N - 1
            PSH
            JSR Fibo              ;           Aufruf
            POP
            SPBP
            STAB Ablage           ;           Ablage := Fibo (N-1)
            LDAB N
            SUB Zwei              ;           Berechne N - 2
            PSH
            JSR Fibo              ;           Aufruf
            POP                   ;           Accu := Fibo (N-2)
            SPBP
            ADDB Ablage           ;           Accu := Accu + Ablage
            STAB N                ;           Fibo := Fibo (N - Eins) +
                                  ;                   Fibo (N - Zwei);
       EndIf2                     ;           END
EndIf1
            POP                   ;   (* Platz fuer Ablage wieder frei *)
            RTN                   ; END; (* Fibo *)