; ************************************************************
; *********** Tuerme von Hanoi fuer DC (ab Version 6.1) ******
; ************************************************************
; Bei Anfangshoehe > 3 sollte bei OUTB Ziel ein
; Breakpoint gesetzt werden, um die Ausgabe verfolgen zu
; koennen. Erst ab ca. 16-17 Scheiben laeuft der Stack in den
; Codebereich. Das kann allerdings dauern. Fuer 6 Scheiben
; benoetigt ein 8--MHz--AT etwa 20s.
; Version fuer DC mit BasePointer BP und Mini-Assembler

; PROGRAM Tuerme_von_Hanoi_rekursiv_mit_DC;

           JMP Anfang
GlobalStart  DEF 01          ; CONST GlobalStart   = 1
GlobalAblage DEF 02          ;       GlobalAblage  = 2
GlobalZiel   DEF 03          ;       GlobalZiel    = 3
GlobalHoehe  DEF 00          ; VAR   GlobalHoehe

                             ; BEGIN (* Hauptprogramm *)
Anfang
           INM  GlobalHoehe  ;   Read (GlobalHoehe)
                             ;   (* Parameter auf Stack legen *)
           PSHM GlobalHoehe  ;   PUSH GlobalHoehe
           PSHM GlobalStart  ;   PUSH GlobalStart
           PSHM GlobalZiel   ;   PUSH GlobalZiel
           PSHM GlobalAblage ;   PUSH GlobalAblage
                             ;   (* und Aufruf der Rekursion *)
           JSR  Transport    ;   Transportiere (GlobalHoehe, GlobalStart,
                             ;                  GlobalZiel, GlobalAblage)
                             ;    (* Von 1 nach 3 ueber 2 *)
           END               ; END  (* Hauptprogramm *)

Transport
                             ; PROCEDURE Transportiere (Hoehe, Start,
                             ;                          Ziel, Ablage);
                             ; BEGIN (* Transportiere *)
        Hoehe   EQUAL 5      ; BP + 5
        Start   EQUAL 4      ; BP + 4
        Ziel    EQUAL 3      ; BP + 3
        Ablage  EQUAL 2      ; BP + 2
        RSpAdr  EQUAL 1      ; BP + 1
           SPBP              ; SP --> BP. SP nach BP, da SP sich bei
                             ; den nachfolgenden PSH-Anweisungen ver-
                             ; veraendert. So bleibt Zugriff auf
                             ; die Parameter auf dem Stack gewaehrleistet.
           LDAB Hoehe
           DEC
                             ;   IF Hoehe-1 > 0 THEN (* Rekursion *)
                             ;        BEGIN
           JNP  EndIf1       ;        (* Parameter auf Stack legen *)
           PSH               ;        PUSH Hoehe-1
           LDAB Start
           PSH               ;        PUSH Start
           LDAB Ablage
           PSH               ;        PUSH Ablage
           LDAB Ziel
           PSH               ;        PUSH Ziel
           JSR  Transport    ;        Transportiere (Hoehe-1, Start,
                             ;                       Ablage, Ziel);
                             ;   END; (* IF *)
EndIf1     SPBP              ; SP --> BP (* neu setzen, da durch  *)
                             ;           (* Rekursion veraendert. *)
           OUTB Start        ;   Write ('Lege Scheibe von Turm <Start> ');
           OUTB Ziel         ;   Write ('             auf Turm <Ziel>.');

           LDAB Hoehe
           DEC
                             ;   IF Hoehe-1 > 0 THEN (* Rekursion *)
                             ;        BEGIN
           JNP  EndIf2       ;        (* Parameter auf Stack legen *)
           PSH               ;        PUSH Hoehe-1
           LDAB Ablage
           PSH               ;        PUSH Ablage
           LDAB Ziel
           PSH               ;        PUSH Ziel
           LDAB Start
           PSH               ;        PUSH Start
           JSR  Transport    ;        Transportiere (Hoehe-1, Ablage,
                             ;                       Ziel, Start);
                             ;        END; (* IF *)
                             ;   Stack am Prozedurende bis auf
                             ;   Ruecksprungadresse vernichten
EndIf2     SPBP              ;   SP --> BP (* siehe oben *)
           LDAB RSpAdr       ;   Ruecksprungadresse an die Spitze
           STAB Hoehe
           POP               ;   vier lokale Variablen vernichten
           POP
           POP
           POP
           RTN               ;  END (* PROCEDURE Transport *)
