/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller;

import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import ch.ethz.fsmgui.view.TransitionLabel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.MouseInputListener;

public class FSMMouseInputListener
implements MouseInputListener {
    int sampleCount = 0;
    protected static int ABOUT_TO_MOVE_STATE = 1;
    protected static int ABOUT_TO_ADD_TRANS = 2;
    protected static int READY_TO_ATTACH_NEW = 4;
    protected static int GRABBED_TRANSITION = 5;
    protected static int READY_TO_ATTACH_EXISTING = 3;
    protected static int TRANSLATE_PLANE = 6;
    protected static int ZOOM_PLANE = 7;
    protected static int JUST_LOOKING = 8;
    protected int status = JUST_LOOKING;
    protected State concernedFAState;
    protected FSMStateInterface concernedState;
    protected Transition concernedTransHead;
    protected Transition concernedTransLabel;
    protected State highlightedState = null;
    protected State formerToState = null;
    protected TransitionLabel draggedFATLabel;
    protected int lastClickX;
    protected int lastClickY;
    protected double currdx;
    protected double currdy;
    protected double currScale;
    private Point2D modCoords = new Point2D.Double();
    private FSMView fascape;
    private FSMControllerInterface controller;

    public FSMMouseInputListener(FSMControllerInterface fSMControllerInterface) {
        this.controller = fSMControllerInterface;
        this.fascape = fSMControllerInterface.getView();
    }

    public void setEditTarget(FSMControllerInterface fSMControllerInterface) {
        this.controller = fSMControllerInterface;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.fascape.getModelCoords(this.modCoords, mouseEvent.getX(), mouseEvent.getY());
        double d = this.modCoords.getX();
        double d2 = this.modCoords.getY();
        this.highlight(d, d2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (this.status == READY_TO_ATTACH_NEW) {
            this.fascape.removeTransition(this.concernedTransHead);
            this.status = JUST_LOOKING;
        }
        this.lastClickX = mouseEvent.getX();
        this.lastClickY = mouseEvent.getY();
        this.fascape.getModelCoords(this.modCoords, mouseEvent.getX(), mouseEvent.getY());
        double d = this.modCoords.getX();
        double d2 = this.modCoords.getY();
        this.highlight(d, d2);
        this.concernedFAState = this.fascape.getStateAt(d, d2);
        this.concernedState = null;
        if (null != this.concernedFAState) {
            this.concernedState = this.concernedFAState.model;
        }
        this.concernedTransLabel = this.fascape.getTransitionLabelAt(d, d2);
        this.fascape.toTop(this.concernedTransLabel);
        this.concernedTransHead = null;
        if (null == this.concernedTransLabel) {
            this.concernedTransHead = this.fascape.getTransitionHeadAt(d, d2);
            this.fascape.toTop(this.concernedTransHead);
        }
        if (((n = mouseEvent.getModifiers()) & 4) > 0 || (n & 0x10) > 0 & (n & 2) > 0) {
            if (null != this.concernedTransLabel) {
                this.fascape.selectTransition(this.concernedTransLabel);
                this.controller.changeTransition(this.concernedTransLabel, mouseEvent.getX(), mouseEvent.getY());
            } else if (null != this.concernedTransHead) {
                this.fascape.selectTransition(this.concernedTransHead);
            } else if (null != this.concernedState) {
                this.controller.changeState(this.concernedState, mouseEvent.getX(), mouseEvent.getY());
            } else if (null == this.concernedTransHead) {
                this.controller.changeFSM(mouseEvent.getX(), mouseEvent.getY());
            }
        } else if ((n & 8) > 0 || (n & 0x10) > 0 & (n & 1) > 0) {
            this.printFAModel(this.controller.getModel());
            this.fascape.print();
            if (mouseEvent.getClickCount() > 1) {
                this.fascape.fit();
                this.fascape.repaint();
            } else {
                this.fascape.setScaleRef(mouseEvent.getX(), mouseEvent.getY());
                this.status = ZOOM_PLANE;
            }
        } else if (null == this.concernedTransHead && null == this.concernedTransLabel) {
            if (null != this.concernedState) {
                if (this.concernedFAState.isBorderHighlighted() && this.controller.addTransitionAllowed(this.concernedState)) {
                    this.status = ABOUT_TO_ADD_TRANS;
                } else if (this.concernedFAState.isCenterHighlighted()) {
                    this.controller.selectState(this.concernedFAState);
                    this.fascape.grabState(this.concernedFAState, d, d2);
                    this.status = ABOUT_TO_MOVE_STATE;
                }
            } else if (mouseEvent.getClickCount() > 1) {
                Point point = this.fascape.getNearestFreePoint(null, (int)d, (int)d2);
                if (null != point) {
                    this.concernedState = this.controller.addState(point.x, point.y);
                    this.concernedFAState = this.fascape.getState(this.concernedState);
                    if (this.concernedFAState != null) {
                        this.highlight(mouseEvent.getX(), mouseEvent.getY());
                        this.fascape.repaint();
                        this.status = ABOUT_TO_MOVE_STATE;
                    }
                }
            } else {
                State state = this.fascape.getSelectedState();
                if (state != null) {
                    this.fascape.selectState(state, false);
                }
                this.fascape.selectState(null, true);
                this.fascape.setTranslationRef(mouseEvent.getX(), mouseEvent.getY());
                this.status = TRANSLATE_PLANE;
            }
        } else {
            this.fascape.selectTransition(this.concernedTransLabel);
            if (null != this.concernedTransHead) {
                this.fascape.selectTransition(this.concernedTransHead);
                this.status = GRABBED_TRANSITION;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        this.fascape.getModelCoords(this.modCoords, mouseEvent.getX(), mouseEvent.getY());
        double d = this.modCoords.getX();
        double d2 = this.modCoords.getY();
        if ((n & 8) > 0) {
            if (this.status == ZOOM_PLANE) {
                this.fascape.scale(mouseEvent.getY());
                this.fascape.repaint();
            }
        } else if ((n & 0x10) > 0) {
            this.limitMousePos(mouseEvent);
            this.fascape.getModelCoords(this.modCoords, mouseEvent.getX(), mouseEvent.getY());
            d = this.modCoords.getX();
            d2 = this.modCoords.getY();
            if (this.status == TRANSLATE_PLANE) {
                this.fascape.translate(mouseEvent.getX(), mouseEvent.getY());
                this.fascape.repaint();
            } else if (this.status == ABOUT_TO_MOVE_STATE) {
                this.fascape.moveState(this.concernedFAState, d, d2);
            } else if (this.status == ABOUT_TO_ADD_TRANS) {
                if (this.concernedFAState != this.fascape.getStateAt(d, d2)) {
                    this.formerToState = null;
                    this.concernedTransHead = this.fascape.addTransition(this.concernedFAState);
                    this.fascape.moveTransition(d, d2, this.concernedTransHead);
                    this.draggedFATLabel = this.concernedTransHead.label.copy();
                    this.status = READY_TO_ATTACH_NEW;
                }
            } else if (this.status == GRABBED_TRANSITION) {
                this.formerToState = this.concernedTransHead.to;
                this.fascape.moveTransition(d, d2, this.concernedTransHead);
                this.draggedFATLabel = this.concernedTransHead.label.copy();
                this.status = READY_TO_ATTACH_EXISTING;
            } else if (this.status == READY_TO_ATTACH_EXISTING || this.status == READY_TO_ATTACH_NEW) {
                State state = this.fascape.getStateAt(d, d2);
                if (null != state) {
                    if (this.concernedTransHead.to != state) {
                        Transition transition;
                        if (null != this.concernedTransHead.to) {
                            this.concernedTransHead.to.removeInTransition(this.concernedTransHead);
                            this.concernedTransHead.label.setFATLabel(this.draggedFATLabel);
                        }
                        if (null != (transition = this.fascape.getTransition(this.concernedTransHead.from, state))) {
                            this.concernedTransHead.label.addFATLabel(transition.label);
                        }
                        this.fascape.TOPOLOGY_CHANGED = true;
                        this.concernedTransHead.setToState(state);
                        state.addInTransition(this.concernedTransHead);
                    }
                } else {
                    this.concernedTransHead.label.setFATLabel(this.draggedFATLabel);
                    this.fascape.moveTransition(d, d2, this.concernedTransHead);
                }
            }
            this.fascape.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Serializable serializable;
        this.limitMousePos(mouseEvent);
        this.fascape.getModelCoords(this.modCoords, mouseEvent.getX(), mouseEvent.getY());
        double d = this.modCoords.getX();
        double d2 = this.modCoords.getY();
        this.highlight(d, d2);
        if (this.status == ABOUT_TO_MOVE_STATE && null != this.concernedFAState) {
            serializable = this.fascape.getNearestFreePoint(this.concernedFAState, (int)(d - this.concernedFAState.getMouseRefX()), (int)(d2 - this.concernedFAState.getMouseRefY()));
            if (null != serializable) {
                this.concernedState.setPosition(((Point)serializable).x, ((Point)serializable).y);
            }
            this.concernedFAState.release();
            this.status = JUST_LOOKING;
        }
        if (this.status == READY_TO_ATTACH_EXISTING || this.status == READY_TO_ATTACH_NEW) {
            this.concernedFAState = serializable = this.fascape.getStateAt(d, d2);
            if (null == serializable) {
                this.fascape.removeTransition(this.concernedTransHead);
                this.controller.changeTransition(this.concernedTransHead, this.formerToState, null);
                this.status = JUST_LOOKING;
            } else if (this.status == READY_TO_ATTACH_EXISTING) {
                this.fascape.removeTransition(this.concernedTransHead);
                this.concernedTransHead.label.setFATLabel(this.draggedFATLabel);
                this.controller.changeTransition(this.concernedTransHead, this.formerToState, (State)serializable);
                this.status = JUST_LOOKING;
            } else if (null != serializable && this.status == READY_TO_ATTACH_NEW) {
                if (this.concernedTransHead.label.number() > 0) {
                    this.fascape.removeTransition(this.concernedTransHead);
                    this.controller.addTransition(this.fascape.getTransition(this.concernedTransHead.from, this.concernedTransHead.to), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.concernedTransHead.to = serializable;
                    this.controller.addTransition(this.concernedTransHead, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void limitMousePos(MouseEvent mouseEvent) {
        if (mouseEvent.getX() < 0) {
            mouseEvent.translatePoint(-mouseEvent.getX(), 0);
        }
        if (mouseEvent.getY() < 0) {
            mouseEvent.translatePoint(0, -mouseEvent.getY());
        }
        if (mouseEvent.getX() > this.fascape.getWidth()) {
            mouseEvent.translatePoint(this.fascape.getWidth() - mouseEvent.getX(), 0);
        }
        if (mouseEvent.getY() > this.fascape.getHeight()) {
            mouseEvent.translatePoint(0, this.fascape.getHeight() - mouseEvent.getY());
        }
    }

    protected void highlight(double d, double d2) {
        State state = this.fascape.getStateAt((int)d, (int)d2);
        if (null != state) {
            if (this.highlightedState != state) {
                this.fascape.dehighlightStates();
            }
            if (this.fascape.onMouseOver(state, (int)d, (int)d2)) {
                this.fascape.repaint();
            }
            this.highlightedState = state;
        } else if (this.highlightedState != null) {
            this.fascape.dehighlightStates();
            this.highlightedState = null;
        }
        Transition transition = this.fascape.getTransitionAt((int)d, (int)d2);
        if (null != transition) {
            this.fascape.dehighlightTransitions();
            transition.setHighlighted(true);
        } else {
            this.fascape.dehighlightTransitions();
        }
    }

    private void printFAModel(FSMModelInterface fSMModelInterface) {
        for (FSMStateInterface fSMStateInterface : fSMModelInterface.getAllStates()) {
            if (null == fSMModelInterface.getAlphabet()) continue;
            for (Character c : fSMModelInterface.getAlphabet()) {
                Set set = fSMStateInterface.getNextStateSet(c);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                }
            }
        }
    }
}

