/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller.popups;

import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.controller.FSMEditorOperations;
import ch.ethz.fsmgui.model.Alphabet;
import ch.ethz.fsmgui.model.Character01Alphabet;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.Transition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class BinaryCharTransitionPopup
implements ActionListener {
    protected Transition concernedTrans;
    protected FSMEditorOperations editorOps;
    protected FSMView fascape;
    protected FSMModelInterface model;
    protected Character01Alphabet alphabet;
    JPopupMenu menu;
    Character epsilon = Alphabet.EPSILON;
    Character zero;
    Character one;

    public BinaryCharTransitionPopup(FSMControllerInterface fSMControllerInterface) {
        this.editorOps = fSMControllerInterface.getFSMEditorOperations();
        this.fascape = fSMControllerInterface.getView();
        this.model = fSMControllerInterface.getModel();
        if (!(this.model.getAlphabet() instanceof Character01Alphabet)) {
            System.out.println("BinaryCharTransitionPopup not suited for Alphabet of current FSM-model " + this.model.getAlphabet().toString());
            System.exit(1);
        }
        this.menu = new JPopupMenu();
    }

    public JPopupMenu getPopup(Transition transition) {
        this.concernedTrans = transition;
        this.alphabet = (Character01Alphabet)this.model.getAlphabet();
        Vector vector = new Vector();
        Transition transition2 = this.fascape.getTransition(transition.from, transition.to);
        if (transition2 != null) {
            vector = transition2.label.getInputs();
        }
        boolean bl = this.alphabet.containsEpsilon() && transition.to != transition.from;
        boolean bl2 = this.concernedTrans.label.number() < 1;
        this.menu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.zero = this.alphabet.getZero();
        this.one = this.alphabet.getOne();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.zero.toString());
        this.menu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(vector.size() == 1 && vector.contains(this.zero));
        jRadioButtonMenuItem = new JRadioButtonMenuItem(this.one.toString());
        this.menu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(vector.size() == 1 && vector.contains(this.one));
        jRadioButtonMenuItem = new JRadioButtonMenuItem(this.zero.toString() + "|" + this.one.toString());
        this.menu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(vector.size() == 2 && vector.contains(this.zero) && vector.contains(this.one));
        if (bl) {
            this.menu.addSeparator();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(this.epsilon.toString());
            this.menu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(vector.contains(this.epsilon));
            jRadioButtonMenuItem = new JRadioButtonMenuItem(this.zero.toString() + "|" + this.epsilon.toString());
            this.menu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(vector.size() == 2 && vector.contains(this.zero) && vector.contains(this.epsilon));
            jRadioButtonMenuItem = new JRadioButtonMenuItem(this.one.toString() + "|" + this.epsilon.toString());
            this.menu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(vector.size() == 2 && vector.contains(this.one) && vector.contains(this.epsilon));
            jRadioButtonMenuItem = new JRadioButtonMenuItem(this.zero.toString() + "|" + this.one.toString() + "|" + this.epsilon.toString());
            this.menu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setSelected(vector.size() == 3 && vector.contains(this.zero) && vector.contains(this.one) && vector.contains(this.epsilon));
        }
        if (!bl2) {
            this.menu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem("Delete");
            this.menu.add(jMenuItem);
            jMenuItem.addActionListener(this);
        }
        return this.menu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.concernedTrans == null) {
            System.out.println("no transition selected");
            return;
        }
        String string = actionEvent.getActionCommand();
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (string == null) {
            System.out.println("no item selected");
        } else if ("Delete".equals(string)) {
            this.editorOps.setTransitionInput(this.concernedTrans, new Object[0]);
        } else if (jMenuItem instanceof JRadioButtonMenuItem) {
            if (this.epsilon.toString().equals(string)) {
                Object[] objectArray = new Character[]{this.epsilon};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if (this.zero.toString().equals(string)) {
                Object[] objectArray = new Character[]{this.zero};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if (this.one.toString().equals(string)) {
                Object[] objectArray = new Character[]{this.one};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if ((this.zero.toString() + "|" + this.one.toString()).equals(string)) {
                Object[] objectArray = new Character[]{this.zero, this.one};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if ((this.zero.toString() + "|" + this.epsilon.toString()).equals(string)) {
                Object[] objectArray = new Character[]{this.zero, this.epsilon};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if ((this.one.toString() + "|" + this.epsilon.toString()).equals(string)) {
                Object[] objectArray = new Character[]{this.one, this.epsilon};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            } else if ((this.zero.toString() + "|" + this.one.toString() + "|" + this.epsilon.toString()).equals(string)) {
                Object[] objectArray = new Character[]{this.zero, this.one, this.epsilon};
                this.editorOps.setTransitionInput(this.concernedTrans, objectArray);
            }
        }
    }
}

