/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller.popups;

import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.view.CircleLayouter;
import ch.ethz.fsmgui.view.Component3DRenderer;
import ch.ethz.fsmgui.view.ComponentContrastRenderer;
import ch.ethz.fsmgui.view.ComponentDiodeRenderer;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.OrganicLayouter;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class DefaultPopup
extends ExceptionActionListener {
    protected static final String ACTION_UNDO = "undo";
    protected static final String ACTION_REDO = "redo";
    protected static final String ACTION_ADD_STATE = "addState";
    protected static final String ACTION_CLEAR = "clear";
    protected static final String ACTION_CHANGE_LABEL = "changeName";
    protected static final String ACTION_LAYOUT_FIT = "layoutFit";
    protected static final String ACTION_LAYOUT_ORGANIC = "layoutOrganic";
    protected static final String ACTION_LAYOUT_CIRCLE = "layoutCircle";
    protected static final String ACTION_LAYOUT_ALIGN = "layoutAlign";
    protected static final String ACTION_STYLE_3D = "style3D";
    protected static final String ACTION_STYLE_CONTRAST = "styleContrast";
    protected static final String ACTION_STYLE_DIODE = "styleDiode";
    protected FSMControllerInterface controller;
    protected FSMView fsmView;
    protected int lastClickX;
    protected int lastClickY;
    private Point2D modCoords = new Point2D.Double();
    protected boolean EPSILONS;
    protected JPopupMenu menu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem addStateItem;
    protected JMenuItem clearItem;
    protected JMenuItem changeNameItem;
    protected JMenu layoutMenu;
    protected JMenuItem fitItem;
    protected JMenuItem organicItem;
    protected JMenuItem circleItem;
    protected JCheckBoxMenuItem alignItem;
    protected JMenu styleMenu;
    protected ButtonGroup styleGroup;
    protected JRadioButtonMenuItem style3D;
    protected JRadioButtonMenuItem styleContrast;
    protected JRadioButtonMenuItem styleDiode;
    protected Frame parent;
    protected FANameDialog faNameDialog;

    public DefaultPopup(FSMControllerInterface fSMControllerInterface, Frame frame) {
        this.controller = fSMControllerInterface;
        this.fsmView = fSMControllerInterface.getView();
        this.parent = frame;
        this.menu = new JPopupMenu();
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setActionCommand(ACTION_UNDO);
        this.undoItem.addActionListener(this);
        this.redoItem = new JMenuItem("Redo");
        this.redoItem.setActionCommand(ACTION_REDO);
        this.redoItem.addActionListener(this);
        this.addStateItem = new JMenuItem("Add state");
        this.addStateItem.setActionCommand(ACTION_ADD_STATE);
        this.addStateItem.addActionListener(this);
        this.clearItem = new JMenuItem("Clear");
        this.clearItem.setActionCommand(ACTION_CLEAR);
        this.clearItem.addActionListener(this);
        this.changeNameItem = new JMenuItem("Change name");
        this.changeNameItem.setActionCommand(ACTION_CHANGE_LABEL);
        this.changeNameItem.addActionListener(this);
        this.layoutMenu = new JMenu("Layout");
        this.fitItem = new JMenuItem("Fit");
        this.fitItem.setActionCommand(ACTION_LAYOUT_FIT);
        this.fitItem.addActionListener(this);
        this.organicItem = new JMenuItem("Organic");
        this.organicItem.setActionCommand(ACTION_LAYOUT_ORGANIC);
        this.organicItem.addActionListener(this);
        this.circleItem = new JMenuItem("Circle");
        this.circleItem.setActionCommand(ACTION_LAYOUT_CIRCLE);
        this.circleItem.addActionListener(this);
        this.alignItem = new JCheckBoxMenuItem("Align with grid");
        this.alignItem.setActionCommand(ACTION_LAYOUT_ALIGN);
        this.alignItem.addActionListener(this);
        this.styleMenu = new JMenu("Style");
        this.styleGroup = new ButtonGroup();
        this.style3D = new JRadioButtonMenuItem("3D");
        this.style3D.setActionCommand(ACTION_STYLE_3D);
        this.styleGroup.add(this.style3D);
        this.style3D.addActionListener(this);
        this.styleContrast = new JRadioButtonMenuItem("Contrast");
        this.styleContrast.setActionCommand(ACTION_STYLE_CONTRAST);
        this.styleGroup.add(this.styleContrast);
        this.styleContrast.addActionListener(this);
        this.styleDiode = new JRadioButtonMenuItem("Diode");
        this.styleDiode.setActionCommand(ACTION_STYLE_DIODE);
        this.styleGroup.add(this.styleDiode);
        this.styleDiode.addActionListener(this);
    }

    public JPopupMenu getPopup(int n, int n2) {
        this.lastClickX = n;
        this.lastClickY = n2;
        this.menu.removeAll();
        this.menu.add(this.undoItem);
        this.undoItem.setEnabled(!this.controller.getFSMEditorOperations().undoListEmpty());
        this.menu.add(this.redoItem);
        this.redoItem.setEnabled(!this.controller.getFSMEditorOperations().redoListEmpty());
        this.menu.addSeparator();
        this.menu.add(this.addStateItem);
        this.menu.add(this.clearItem);
        this.menu.add(this.getLayoutMenu());
        this.menu.add(this.getStyleMenu());
        this.menu.add(this.changeNameItem);
        return this.menu;
    }

    protected JMenu getLayoutMenu() {
        this.layoutMenu.removeAll();
        this.layoutMenu.add(this.fitItem);
        this.layoutMenu.addSeparator();
        this.layoutMenu.add(this.organicItem);
        this.layoutMenu.add(this.circleItem);
        this.layoutMenu.addSeparator();
        this.layoutMenu.add(this.alignItem);
        if (this.fsmView.isGridAligned()) {
            this.alignItem.setState(true);
        }
        return this.layoutMenu;
    }

    protected JMenu getStyleMenu() {
        this.styleMenu.removeAll();
        this.styleMenu.add(this.style3D);
        if (this.fsmView.getChosenRendererKey().equals(Component3DRenderer.key)) {
            this.style3D.setSelected(true);
        }
        this.styleMenu.add(this.styleContrast);
        if (this.fsmView.getChosenRendererKey().equals(ComponentContrastRenderer.key)) {
            this.styleContrast.setSelected(true);
        }
        this.styleMenu.add(this.styleDiode);
        if (this.fsmView.getChosenRendererKey().equals(ComponentDiodeRenderer.key)) {
            this.styleDiode.setSelected(true);
        }
        return this.styleMenu;
    }

    public void undo(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().undo();
    }

    public void redo(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().redo();
    }

    public void addState(ActionEvent actionEvent) {
        this.fsmView.getModelCoords(this.modCoords, this.lastClickX, this.lastClickY);
        double d = this.modCoords.getX();
        double d2 = this.modCoords.getY();
        Point point = this.fsmView.getNearestFreePoint(null, (int)d, (int)d2);
        if (null != point) {
            this.controller.addState(point.x, point.y);
        }
    }

    public void clear(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().clear();
    }

    public void layoutFit(ActionEvent actionEvent) {
        this.fsmView.fit();
        this.fsmView.repaint();
    }

    public void layoutAlign(ActionEvent actionEvent) {
        if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
            this.fsmView.alignWithGrid(true);
            this.fsmView.fit();
            this.fsmView.repaint();
        } else {
            this.fsmView.alignWithGrid(false);
        }
    }

    public void layoutOrganic(ActionEvent actionEvent) {
        OrganicLayouter.layout(this.fsmView);
        this.fsmView.fit();
        this.fsmView.repaint();
    }

    public void layoutCircle(ActionEvent actionEvent) {
        CircleLayouter.layout(this.fsmView);
        this.fsmView.fit();
        this.fsmView.repaint();
    }

    public void style3D(ActionEvent actionEvent) {
        this.fsmView.chooseRenderer("3D");
        this.fsmView.repaint();
    }

    public void styleContrast(ActionEvent actionEvent) {
        this.fsmView.chooseRenderer("Contrast");
        this.fsmView.repaint();
    }

    public void styleDiode(ActionEvent actionEvent) {
        this.fsmView.chooseRenderer("Diode");
        this.fsmView.repaint();
    }

    public void changeName(ActionEvent actionEvent) {
        if (null == this.faNameDialog) {
            this.faNameDialog = new FANameDialog(this.parent);
        }
        this.faNameDialog.setVisible(true);
    }

    public class FANameDialog
    extends Dialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        TextField t;

        FANameDialog(Frame frame) {
            super(frame, "Change FA name", true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FANameDialog.this.dispose();
                }
            });
            this.setLayout(new FlowLayout());
            this.t = new TextField(15);
            this.t.setText(DefaultPopup.this.fsmView.getModel().getName());
            this.add(this.t);
            this.t.addActionListener(this);
            JButton jButton = new JButton("ok");
            this.add(jButton);
            jButton.addActionListener(this);
            this.pack();
            Point point = DefaultPopup.this.fsmView.getLocationOnScreen();
            this.setLocation(point.x + DefaultPopup.this.fsmView.getWidth() / 2 - this.getWidth() / 2, point.y + DefaultPopup.this.fsmView.getHeight() / 2 - this.getHeight() / 2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultPopup.this.controller.getFSMEditorOperations().setFAName(this.t.getText());
            this.dispose();
        }
    }
}

