/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.ComponentRenderer;
import ch.ethz.fsmgui.view.Transition;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

public class State
extends JComponent {
    private static final long serialVersionUID = 1L;
    boolean HIGHLIGHT_CENTER = false;
    boolean HIGHLIGHT_BORDER = false;
    boolean SELECTED = false;
    public Object mark = ComponentRenderer.MARK_NOT_MARKED;
    boolean ACCEPTING = false;
    boolean START = false;
    String label;
    String visibleLabel;
    Shape labelShape;
    float labelOffsX;
    float labelOffsY;
    public FSMStateInterface model;
    Hashtable<ComponentRenderer, Float> fontSizes = new Hashtable();
    public Vector<Transition> outTransitions = new Vector();
    public Vector<Transition> inTransitions = new Vector();
    double centerX;
    double centerY;
    double x;
    double y;
    double width;
    double height;
    double mouseRefX;
    double mouseRefY;
    boolean SHOW_WHOLE_LABEL = false;
    private Font font;

    public State(FSMStateInterface fSMStateInterface) {
        this.model = fSMStateInterface;
        this.label = fSMStateInterface.getLabel().toString();
        this.setAccepting(fSMStateInterface.isAccepting());
        this.setStart(fSMStateInterface.isStartState());
        this.centerX = fSMStateInterface.getX();
        this.centerY = fSMStateInterface.getY();
    }

    boolean hasTransitionTo(State state) {
        for (int i = 0; i < this.outTransitions.size(); ++i) {
            if (this.outTransitions.elementAt((int)i).to != state) continue;
            return true;
        }
        return false;
    }

    public void setBorderHighlighted(boolean bl) {
        this.HIGHLIGHT_BORDER = bl;
    }

    public boolean isBorderHighlighted() {
        return this.HIGHLIGHT_BORDER;
    }

    public void setCenterHighlighted(boolean bl) {
        this.HIGHLIGHT_CENTER = bl;
    }

    public boolean isCenterHighlighted() {
        return this.HIGHLIGHT_CENTER;
    }

    public void setSelected(boolean bl) {
        this.SELECTED = bl;
    }

    public boolean isSelected() {
        return this.SELECTED;
    }

    public void setMark(Object object) {
        this.mark = object;
    }

    public Object getMark() {
        return this.mark;
    }

    public void setAccepting(boolean bl) {
        this.ACCEPTING = bl;
    }

    public boolean isAccepting() {
        return this.ACCEPTING;
    }

    public void setStart(boolean bl) {
        this.START = bl;
    }

    public boolean isStart() {
        return this.START;
    }

    public void setLabel(Object object) {
        this.label = object.toString();
        this.fontSizes.clear();
    }

    public String getLabel() {
        return this.label;
    }

    public void setVisibleLabel(String string) {
        this.visibleLabel = string;
    }

    public String getVisibleLabel() {
        return this.visibleLabel;
    }

    public void setFontSize(ComponentRenderer componentRenderer, float f) {
        this.fontSizes.put(componentRenderer, new Float(f));
    }

    public Float getFontSize(ComponentRenderer componentRenderer) {
        return this.fontSizes.get(componentRenderer);
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Rectangle getWholeLabelBounds(FontMetrics fontMetrics) {
        return new Rectangle((int)(this.centerX - (double)(fontMetrics.stringWidth(this.getLabel()) / 2)) - 3, (int)(this.centerY - (double)(fontMetrics.getHeight() / 2)), fontMetrics.stringWidth(this.getLabel()) + 6, fontMetrics.getHeight());
    }

    public void grab(double d, double d2) {
        this.mouseRefX = d - this.centerX;
        this.mouseRefY = d2 - this.centerY;
    }

    public void release() {
        this.mouseRefX = 0.0;
        this.mouseRefY = 0.0;
    }

    public double getMouseRefX() {
        return this.mouseRefX;
    }

    public double getMouseRefY() {
        return this.mouseRefY;
    }

    public void addOutTransition(Transition transition) {
        this.outTransitions.addElement(transition);
    }

    public void removeOutTransition(Transition transition) {
        this.outTransitions.remove(transition);
    }

    public void addInTransition(Transition transition) {
        this.inTransitions.addElement(transition);
    }

    public void removeInTransition(Transition transition) {
        this.inTransitions.remove(transition);
    }

    public void setCenter(double d, double d2) {
        this.centerX = d;
        this.centerY = d2;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public Transition getSelfTransition() {
        for (int i = 0; i < this.outTransitions.size(); ++i) {
            Transition transition = this.outTransitions.elementAt(i);
            if (transition.to != this) continue;
            return transition;
        }
        return null;
    }
}

