/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.view.ComponentRenderer;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.TransitionLabel;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;

public class Transition {
    public static int LINE = 1;
    public static int QUAD = 2;
    public static int CUBIC = 3;
    int type;
    boolean HIGHLIGHTED = false;
    boolean SELECTED = false;
    public Object mark = ComponentRenderer.MARK_NOT_MARKED;
    public TransitionLabel label;
    public State from;
    public State to;
    double fromX;
    double fromY;
    double toX;
    double toY;
    double ctrlFromX;
    double ctrlFromY;
    double ctrlToX;
    double ctrlToY;
    double angle;
    double angleHead;
    GeneralPath headGP = new GeneralPath(1, 4);
    GeneralPath sensHeadGP = new GeneralPath(1, 4);

    Transition(State state, Object object) {
        this.label = new TransitionLabel(this, object);
        this.from = state;
        this.toX = state.getCenterX();
        this.toY = state.getCenterY();
        this.type = LINE;
    }

    public Transition(State state, State state2, Object object) {
        this.label = new TransitionLabel(this, object);
        this.from = state;
        this.to = state2;
        this.type = state == state2 ? CUBIC : (state2.hasTransitionTo(state) ? QUAD : LINE);
    }

    public void setHighlighted(boolean bl) {
        this.HIGHLIGHTED = bl;
    }

    public boolean isHighlighted() {
        return this.HIGHLIGHTED;
    }

    public void setSelected(boolean bl) {
        this.SELECTED = bl;
    }

    public boolean isSelected() {
        return this.SELECTED;
    }

    public void setMark(Object object) {
        this.mark = object;
    }

    public Object getMark() {
        return this.mark;
    }

    public void setTo(double d, double d2) {
        this.toX = d;
        this.toY = d2;
    }

    public void setToState(State state) {
        this.to = state;
    }

    public Shape getCurve() {
        if (this.type == CUBIC) {
            return new CubicCurve2D.Double(this.fromX, this.fromY, this.ctrlFromX, this.ctrlFromY, this.ctrlToX, this.ctrlToY, this.toX, this.toY);
        }
        if (this.type == QUAD) {
            return new QuadCurve2D.Double(this.fromX, this.fromY, this.ctrlFromX, this.ctrlFromY, this.toX, this.toY);
        }
        if (this.type == LINE) {
            return new Line2D.Double(this.fromX, this.fromY, this.toX, this.toY);
        }
        return new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }
}

