/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.editor;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorListenerInterface;
import ch.karatojava.editor.EditorListenerSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class AbstractEditor
implements EditorInterface {
    protected File currentFile;
    protected boolean hasContent;
    protected EditorListenerSupport listenerSupport = new EditorListenerSupport(this);

    @Override
    public void addEditorListener(EditorListenerInterface editorListenerInterface) {
        this.listenerSupport.addEditorListener(editorListenerInterface);
    }

    @Override
    public void removeEditorListener(EditorListenerInterface editorListenerInterface) {
        this.listenerSupport.removeEditorListener(editorListenerInterface);
    }

    @Override
    public List getEditorListeners() {
        return this.listenerSupport.getListeners();
    }

    @Override
    public boolean hasContent() {
        return this.hasContent || this.isModified();
    }

    @Override
    public File getCurrentFile() {
        return this.currentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File file) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.doSave(fileOutputStream);
            this.currentFile = file;
            this.resetModified();
            this.listenerSupport.fireSavedContent();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File file) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.doSetContent(this.create(fileInputStream));
            this.resetModified();
            this.currentFile = file;
            this.hasContent = true;
            this.listenerSupport.fireLoadedContent();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.setContent(this.create(inputStream));
    }

    @Override
    public void setContent(Object object) {
        this.doSetContent(object);
        this.resetModified();
        this.currentFile = null;
        this.hasContent = true;
        this.listenerSupport.fireLoadedContent();
    }

    @Override
    public void newFile() {
        this.doNewFile();
        this.resetModified();
        this.currentFile = null;
        this.hasContent = false;
        this.listenerSupport.fireNewContent();
    }

    protected abstract void doSave(OutputStream var1) throws Exception;

    protected abstract void doSetContent(Object var1);

    protected abstract void doNewFile();

    protected abstract void resetModified();
}

