/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.editor;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorListenerInterface;
import ch.karatojava.editor.EditorToolbarUiFactoryInterface;
import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class EditorIoToolbar
extends JPanel {
    protected static final long serialVersionUID = 7534465479868137123L;
    protected static final String FILENAME_PREFIX = " [ ";
    protected static final String FILENAME_MODIFIED_PREFIX = " [ * ";
    protected static final String FILENAME_POSTFIX = " ] ";
    protected EditorToolbarUiFactoryInterface uiFactory;
    protected EditorInterface editor;
    protected TitledBorder border;
    protected JButton[] buttons;
    protected boolean[] commandsEnabled;
    protected JFileChooser chooser;
    protected ExampleFileFilter fileFilter;
    protected String extension;
    protected File currentFile;
    protected boolean modified;

    public EditorIoToolbar(EditorInterface editorInterface, EditorToolbarUiFactoryInterface editorToolbarUiFactoryInterface, String string) {
        this.editor = editorInterface;
        this.extension = string;
        this.uiFactory = editorToolbarUiFactoryInterface;
        this.chooser = editorToolbarUiFactoryInterface.getFileChooser();
        this.fileFilter = editorToolbarUiFactoryInterface.getFileFilter();
        this.modified = false;
        editorToolbarUiFactoryInterface.setEditorToolbar(this);
        editorInterface.addEditorListener(this.createEditorListener());
        this.commandsEnabled = new boolean[5];
        for (int i = 0; i < this.commandsEnabled.length; ++i) {
            this.commandsEnabled[i] = true;
        }
        this.createGUI();
        this.buttons[Command.NEW.index].addActionListener(new ExceptionActionListener(this, "newFile"));
        this.buttons[Command.LOAD.index].addActionListener(new ExceptionActionListener(this, "loadFile"));
        this.buttons[Command.RELOAD.index].addActionListener(new ExceptionActionListener(this, "reloadFile"));
        this.buttons[Command.SAVE.index].addActionListener(new ExceptionActionListener(this, "saveFile"));
        this.buttons[Command.SAVEAS.index].addActionListener(new ExceptionActionListener(this, "saveAsFile"));
    }

    protected EditorListenerInterface createEditorListener() {
        return new EditorListener();
    }

    public EditorInterface getEditor() {
        return this.editor;
    }

    public EditorToolbarUiFactoryInterface getUiFactory() {
        return this.uiFactory;
    }

    public void disableCommand(Command command) {
        this.commandsEnabled[command.index] = false;
    }

    public void enableCommand(Command command) {
        this.commandsEnabled[command.index] = true;
    }

    public void newFile() throws Exception {
        this.checkEnabled(Command.NEW);
        if (this.canChangeContent()) {
            this.editor.newFile();
        }
    }

    public boolean saveAsFile() throws Exception {
        this.checkEnabled(Command.SAVEAS);
        this.chooser.setFileFilter(this.fileFilter);
        this.chooser.rescanCurrentDirectory();
        int n = this.chooser.showSaveDialog(JOptionPane.getFrameForComponent(this));
        File file = this.chooser.getSelectedFile();
        if (n == 0 && file != null) {
            File file2;
            String string = file.getAbsolutePath();
            if (!string.endsWith("." + this.extension)) {
                string = string + "." + this.extension;
            }
            if ((file2 = new File(string)).exists() && this.uiFactory.askOverwrite(string) != 0) {
                return false;
            }
            this.setFile(file2);
            return this.doSave();
        }
        return false;
    }

    public boolean saveFile() throws Exception {
        this.checkEnabled(Command.SAVE);
        if (this.modified) {
            if (this.currentFile == null) {
                return this.saveAsFile();
            }
            return this.doSave();
        }
        return true;
    }

    public void reloadFile() throws Exception {
        this.checkEnabled(Command.RELOAD);
        if (this.currentFile != null) {
            File file = this.currentFile;
            this.currentFile = null;
            if (this.canChangeContent()) {
                this.currentFile = file;
                this.editor.load(this.currentFile);
            } else {
                this.currentFile = file;
            }
        }
    }

    public void loadFile() throws Exception {
        this.checkEnabled(Command.LOAD);
        if (this.canChangeContent()) {
            File file;
            this.chooser.rescanCurrentDirectory();
            this.chooser.setFileFilter(this.fileFilter);
            if (this.chooser.showOpenDialog(JOptionPane.getFrameForComponent(this)) == 0 && (file = this.chooser.getSelectedFile()) != null) {
                this.loadFile(file);
            }
        }
    }

    public void loadFile(File file) throws Exception {
        String string = file.getAbsolutePath();
        if (!string.endsWith("." + this.extension)) {
            string = string + "." + this.extension;
        }
        this.editor.load(new File(string));
    }

    protected void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.border = this.uiFactory.createTitledBorder();
        this.setBorder(this.border);
        this.currentFile = null;
        this.setFile(null);
        this.buttons = new JButton[5];
        this.buttons[Command.NEW.index] = this.uiFactory.createButton(Command.NEW);
        this.buttons[Command.LOAD.index] = this.uiFactory.createButton(Command.LOAD);
        this.buttons[Command.RELOAD.index] = this.uiFactory.createButton(Command.RELOAD);
        this.buttons[Command.RELOAD.index].setEnabled(false);
        this.buttons[Command.SAVE.index] = this.uiFactory.createButton(Command.SAVE);
        this.buttons[Command.SAVEAS.index] = this.uiFactory.createButton(Command.SAVEAS);
        Dimension dimension = new Dimension(this.uiFactory.getStrut(), 0);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.add(this.buttons[i]);
            this.add(Box.createRigidArea(dimension));
        }
    }

    protected void setFile(File file) {
        this.currentFile = file;
        this.updateFileNameDisplay();
    }

    protected void checkEnabled(Command command) throws Exception {
        if (!this.commandsEnabled[command.index]) {
            throw new Exception(this.uiFactory.getNotEnabledException(command));
        }
    }

    protected void updateFileNameDisplay() {
        String string = FILENAME_PREFIX;
        if (this.modified) {
            string = FILENAME_MODIFIED_PREFIX;
        }
        if (this.currentFile != null) {
            this.border.setTitle(string + this.currentFile.getName() + FILENAME_POSTFIX);
        } else {
            this.border.setTitle(string + this.uiFactory.getNoNameTitle() + FILENAME_POSTFIX);
        }
        this.repaint();
    }

    public boolean canChangeContent() throws Exception {
        if (this.modified) {
            int n = this.uiFactory.askSave();
            switch (n) {
                case 0: {
                    return this.currentFile != null ? this.saveFile() : this.saveAsFile();
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean doSave() throws Exception {
        this.editor.save(this.currentFile);
        return true;
    }

    public static final class Command {
        protected int index;
        public static final Command NEW = new Command(0);
        public static final Command LOAD = new Command(1);
        public static final Command RELOAD = new Command(2);
        public static final Command SAVE = new Command(3);
        public static final Command SAVEAS = new Command(4);

        protected Command(int n) {
            this.index = n;
        }
    }

    protected class EditorListener
    implements EditorListenerInterface {
        protected EditorListener() {
        }

        protected void update() {
            EditorIoToolbar.this.modified = EditorIoToolbar.this.editor.isModified();
            EditorIoToolbar.this.currentFile = EditorIoToolbar.this.editor.getCurrentFile();
            EditorIoToolbar.this.updateFileNameDisplay();
            EditorIoToolbar.this.buttons[Command.RELOAD.index].setEnabled(EditorIoToolbar.this.modified && EditorIoToolbar.this.currentFile != null);
        }

        @Override
        public void loadedContent(EditorInterface editorInterface) {
            this.update();
        }

        @Override
        public void savedContent(EditorInterface editorInterface) {
            this.update();
        }

        @Override
        public void modifiedContent(EditorInterface editorInterface) {
            this.update();
        }

        @Override
        public void newContent(EditorInterface editorInterface) {
            this.update();
        }
    }
}

