/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.editor;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorListenerInterface;
import java.util.ArrayList;
import java.util.List;

public class EditorListenerSupport {
    protected List<EditorListenerInterface> listeners = new ArrayList<EditorListenerInterface>();
    protected EditorListenerInterface[] listenersArray = new EditorListenerInterface[this.listeners.size()];
    protected EditorInterface editor;

    public EditorListenerSupport(EditorInterface editorInterface) {
        this.listeners.toArray(this.listenersArray);
        this.editor = editorInterface;
    }

    public EditorInterface getEditor() {
        return this.editor;
    }

    public void addEditorListener(EditorListenerInterface editorListenerInterface) {
        this.listeners.add(editorListenerInterface);
        this.listenersArray = new EditorListenerInterface[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public void removeEditorListener(EditorListenerInterface editorListenerInterface) {
        this.listeners.remove(editorListenerInterface);
        this.listenersArray = new EditorListenerInterface[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public List getListeners() {
        return this.listeners;
    }

    public void fireLoadedContent() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].loadedContent(this.editor);
        }
    }

    public void fireSavedContent() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].savedContent(this.editor);
        }
    }

    public void fireModifiedContent() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].modifiedContent(this.editor);
        }
    }

    public void fireNewContent() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].newContent(this.editor);
        }
    }
}

