/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.ToolbarUiFactoryInterface;
import ch.karatojava.util.ExceptionActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DefaultToolbarUiFactory
implements ToolbarUiFactoryInterface {
    public static final int MIN_WAIT_INTERVAL = 1;
    public static final int MAX_WAIT_INTERVAL = 1200;
    public static final int MAJOR_TICK_SPACING = 500;
    public static final int MINOR_TICK_SPACING = 125;
    public static final int BUTTON_SPACING = 8;
    protected InterpreterToolbar toolbar;

    @Override
    public void setInterpreterToolbar(InterpreterToolbar interpreterToolbar) {
        this.toolbar = interpreterToolbar;
    }

    protected InterpreterToolbar getInterpreterToolbar() {
        return this.toolbar;
    }

    @Override
    public int getMinWaitInterval() {
        return 1;
    }

    @Override
    public int getMaxWaitInterval() {
        return 1200;
    }

    @Override
    public int getMajorTickSpacing() {
        return 500;
    }

    @Override
    public int getMinorTickSpacing() {
        return 125;
    }

    @Override
    public int getButtonSpacing() {
        return 8;
    }

    @Override
    public ExceptionHandler createExceptionHandler() {
        return new ExceptionHandler(){

            @Override
            public void handleException(Exception exception) {
                ExceptionActionListener.reportException(DefaultToolbarUiFactory.this.toolbar, "Error: " + exception.getClass().getName(), exception);
            }
        };
    }

    private ImageIcon loadImageIcon(String string) {
        return new ImageIcon(DefaultToolbarUiFactory.class.getResource("/interpretericons/" + string));
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(this.loadImageIcon(string + ".gif"));
        jButton.setBorderPainted(false);
        return jButton;
    }

    @Override
    public JButton createStepButton() {
        return this.createButton("step");
    }

    @Override
    public JButton createPlayButton() {
        return this.createButton("play");
    }

    @Override
    public JButton createPauseButton() {
        return this.createButton("pause");
    }

    @Override
    public JButton createStopButton() {
        return this.createButton("stop");
    }

    @Override
    public JLabel createSlowerLabel() {
        return new JLabel("slower");
    }

    @Override
    public JLabel createFasterLabel() {
        return new JLabel("faster");
    }

    @Override
    public Border createSpeedSliderBorder() {
        return new TitledBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor"), 2), "Speed of execution");
    }

    @Override
    public Border createButtonsBorder() {
        return new TitledBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor"), 2), "Control interpreter");
    }
}

