/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterface;
import ch.karatojava.interpreter.ToolbarUiFactoryInterface;
import ch.karatojava.util.ExceptionActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InterpreterToolbar
extends JPanel {
    private static final long serialVersionUID = 6570285950094760717L;
    protected RunnableInterface interpreter;
    protected JButton stepButton;
    protected JButton playButton;
    protected JButton pauseButton;
    protected JButton stopButton;
    protected JSlider speed;
    protected JPanel buttons;
    protected ToolbarInterpreterListener interpreterListener;
    protected boolean listenerInUse;
    protected ToolbarUiFactoryInterface uiFactory;

    public InterpreterToolbar(ToolbarUiFactoryInterface toolbarUiFactoryInterface, RunnableInterface runnableInterface) {
        this.interpreter = runnableInterface;
        this.uiFactory = toolbarUiFactoryInterface;
        this.interpreterListener = this.createNewToolbarInterpreterListener();
        runnableInterface.addInterpreterListener(this.interpreterListener);
        this.listenerInUse = true;
        toolbarUiFactoryInterface.setInterpreterToolbar(this);
        ExceptionHandler exceptionHandler = toolbarUiFactoryInterface.createExceptionHandler();
        if (exceptionHandler != null) {
            runnableInterface.setExceptionHandler(exceptionHandler);
        }
        this.createGui();
    }

    protected void createAndAddButtons(JPanel jPanel) {
        if (this.interpreter instanceof StepableInterface) {
            this.stepButton = this.uiFactory.createStepButton();
            this.stepButton.addActionListener(new ExceptionActionListener(this, "step"));
            this.stepButton.setEnabled(true);
            jPanel.add(this.stepButton);
        }
        this.playButton = this.uiFactory.createPlayButton();
        this.playButton.addActionListener(new ExceptionActionListener(this, "play"));
        this.playButton.setEnabled(true);
        jPanel.add(this.playButton);
        this.pauseButton = this.uiFactory.createPauseButton();
        this.pauseButton.addActionListener(new ExceptionActionListener(this, "pause"));
        this.pauseButton.setEnabled(false);
        jPanel.add(this.pauseButton);
        this.stopButton = this.uiFactory.createStopButton();
        this.stopButton.addActionListener(new ExceptionActionListener(this, "stop"));
        this.stopButton.setEnabled(false);
        jPanel.add(this.stopButton);
    }

    protected JSlider createSpeedSlider() {
        int n = (this.uiFactory.getMaxWaitInterval() - this.uiFactory.getMinWaitInterval()) / 2;
        this.interpreter.setWaitInterval(n);
        JSlider jSlider = new JSlider(0, this.uiFactory.getMinWaitInterval(), this.uiFactory.getMaxWaitInterval(), n);
        jSlider.setMajorTickSpacing(this.uiFactory.getMajorTickSpacing());
        jSlider.setMinorTickSpacing(this.uiFactory.getMinorTickSpacing());
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        hashtable.put(new Integer(this.uiFactory.getMinWaitInterval()), this.uiFactory.createSlowerLabel());
        hashtable.put(new Integer(this.uiFactory.getMaxWaitInterval()), this.uiFactory.createFasterLabel());
        jSlider.setLabelTable(hashtable);
        jSlider.setBorder(this.uiFactory.createSpeedSliderBorder());
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InterpreterToolbar.this.interpreter.setWaitInterval(InterpreterToolbar.this.uiFactory.getMaxWaitInterval() + InterpreterToolbar.this.uiFactory.getMinWaitInterval() - InterpreterToolbar.this.speed.getValue());
            }
        });
        return jSlider;
    }

    protected void createGui() {
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 0));
        this.buttons.setBorder(this.uiFactory.createButtonsBorder());
        this.createAndAddButtons(this.buttons);
        this.speed = this.createSpeedSlider();
        this.buttons.setAlignmentY(this.speed.getAlignmentY());
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.speed);
        this.add(Box.createHorizontalStrut(this.uiFactory.getButtonSpacing()));
        this.add(this.buttons);
    }

    protected ToolbarInterpreterListener createNewToolbarInterpreterListener() {
        return new ToolbarInterpreterListener();
    }

    public RunnableInterface getInterpreter() {
        return this.interpreter;
    }

    public JButton[] getButtons() {
        return new JButton[]{this.stepButton, this.playButton, this.pauseButton, this.stopButton};
    }

    public void disableAllButtons() {
        if (this.stepButton != null) {
            this.stepButton.setEnabled(false);
        }
        this.playButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    public void resetButtons() {
        if (this.stepButton != null) {
            this.stepButton.setEnabled(true);
        }
        this.playButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    public void stopUpdatingButtonsState() {
        if (this.listenerInUse) {
            this.interpreter.removeInterpreterListener(this.interpreterListener);
            this.listenerInUse = false;
        }
    }

    public void startUpdatingButtonsState() {
        if (!this.listenerInUse) {
            this.interpreter.addInterpreterListener(this.interpreterListener);
            this.listenerInUse = true;
        }
    }

    protected void disablePlayButtons() {
        this.stepButton.setEnabled(false);
        this.playButton.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void play() throws InterpreterException {
        boolean bl = false;
        RunnableInterface runnableInterface = this.interpreter;
        synchronized (runnableInterface) {
            boolean bl2 = bl = this.interpreter.getState() != RunnableInterface.State.RUNNING;
            if (bl) {
                this.disableAllButtons();
            }
        }
        if (bl) {
            this.interpreter.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void step() throws InterpreterException {
        boolean bl = false;
        RunnableInterface runnableInterface = this.interpreter;
        synchronized (runnableInterface) {
            boolean bl2 = bl = this.interpreter.getState() != RunnableInterface.State.RUNNING;
            if (bl) {
                this.disablePlayButtons();
            }
        }
        if (bl) {
            ((StepableInterface)this.interpreter).step();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() throws InterpreterException {
        boolean bl = false;
        RunnableInterface runnableInterface = this.interpreter;
        synchronized (runnableInterface) {
            boolean bl2 = bl = this.interpreter.getState() != RunnableInterface.State.IDLE;
            if (bl) {
                this.disableAllButtons();
            }
        }
        if (bl) {
            this.interpreter.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws InterpreterException {
        boolean bl = false;
        RunnableInterface runnableInterface = this.interpreter;
        synchronized (runnableInterface) {
            boolean bl2 = bl = this.interpreter.getState() != RunnableInterface.State.IDLE;
            if (bl) {
                this.disableAllButtons();
            }
        }
        if (bl) {
            this.interpreter.stop();
        }
    }

    public void setInterpreter(RunnableInterface runnableInterface) {
        this.interpreter.removeInterpreterListener(this.interpreterListener);
        this.interpreter = runnableInterface;
        runnableInterface.addInterpreterListener(this.interpreterListener);
        this.listenerInUse = true;
        int n = (this.uiFactory.getMaxWaitInterval() - this.uiFactory.getMinWaitInterval()) / 2;
        runnableInterface.setWaitInterval(n);
        this.speed.setValue(n);
        this.revalidate();
    }

    protected class ToolbarInterpreterListener
    extends InterpreterListenerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                if (InterpreterToolbar.this.stepButton != null) {
                    InterpreterToolbar.this.stepButton.setEnabled(true);
                }
                InterpreterToolbar.this.playButton.setEnabled(true);
                InterpreterToolbar.this.pauseButton.setEnabled(false);
                InterpreterToolbar.this.stopButton.setEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void playing(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                if (InterpreterToolbar.this.stepButton != null) {
                    InterpreterToolbar.this.stepButton.setEnabled(false);
                }
                InterpreterToolbar.this.playButton.setEnabled(false);
                InterpreterToolbar.this.pauseButton.setEnabled(true);
                InterpreterToolbar.this.stopButton.setEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pausing(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                this.gotReady(runnableInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginCompositeStep(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                if (runnableInterface.getState() == StepableInterface.State.STEPPING) {
                    InterpreterToolbar.this.stepButton.setEnabled(false);
                    InterpreterToolbar.this.playButton.setEnabled(false);
                    InterpreterToolbar.this.pauseButton.setEnabled(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endCompositeStep(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                if (runnableInterface.getState() != StepableInterface.State.RUNNING) {
                    this.gotReady(runnableInterface);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopped(RunnableInterface runnableInterface) {
            RunnableInterface runnableInterface2 = runnableInterface;
            synchronized (runnableInterface2) {
                if (InterpreterToolbar.this.stepButton != null) {
                    InterpreterToolbar.this.stepButton.setEnabled(true);
                }
                InterpreterToolbar.this.playButton.setEnabled(true);
                InterpreterToolbar.this.pauseButton.setEnabled(false);
                InterpreterToolbar.this.stopButton.setEnabled(false);
            }
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.stopped(runnableInterface);
        }
    }
}

