/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerSupport;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.Scheduler;
import ch.karatojava.interpreter.StepableInterface;
import ch.karatojava.interpreter.StepableInterpreterThread;
import ch.karatojava.interpreter.StepperInterface;
import ch.karatojava.util.CyclicBarrier;

public class StepableInterpreter
implements StepableInterface {
    protected StepperInterface stepper;
    protected InterpreterListenerSupport listenerSupport;
    protected ExceptionHandler exceptionHandler;
    protected int waitInterval;
    protected RunnableInterface.State state;
    protected StepableInterpreterThread interpreterRunnable;
    protected CyclicBarrier barrier;

    public StepableInterpreter(StepperInterface stepperInterface) {
        this.stepper = stepperInterface;
        this.listenerSupport = new InterpreterListenerSupport(this);
        this.state = RunnableInterface.State.IDLE;
        this.barrier = new CyclicBarrier(2);
        this.interpreterRunnable = new StepableInterpreterThread(this, stepperInterface, this.barrier);
        new Thread(this.interpreterRunnable).start();
        this.barrier.waitBarrierIgnoreInterrupt("interpreter");
    }

    @Override
    public synchronized void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized void setWaitInterval(int n) {
        this.waitInterval = n;
    }

    @Override
    public synchronized RunnableInterface.State getState() {
        return this.state;
    }

    public synchronized StepperInterface getStepper() {
        if (this.stepper instanceof Scheduler) {
            return ((Scheduler)this.stepper).getCurrentStepper();
        }
        return this.stepper;
    }

    @Override
    public synchronized int getWaitInterval() {
        return this.waitInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        RunnableInterface.State state = this.state;
        StepableInterpreter stepableInterpreter = this;
        synchronized (stepableInterpreter) {
            this.state = RunnableInterface.State.RUNNING;
        }
        if (state == RunnableInterface.State.IDLE) {
            this.barrier.waitBarrierIgnoreInterrupt("interpreter.play1");
        }
        stepableInterpreter = this;
        synchronized (stepableInterpreter) {
            if (this.state == RunnableInterface.State.IDLE) {
                return;
            }
        }
        this.barrier.waitBarrierIgnoreInterrupt("interpreter.play2");
    }

    @Override
    public synchronized void pause() {
        if (this.state != RunnableInterface.State.IDLE) {
            this.state = RunnableInterface.State.PAUSING;
            this.interpreterRunnable.signalPauseInterpreter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step() {
        StepableInterpreter stepableInterpreter = this;
        synchronized (stepableInterpreter) {
            this.state = StepableInterface.State.STEPPING;
        }
        this.barrier.waitBarrierIgnoreInterrupt("interpreter.step");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        RunnableInterface.State state = this.state;
        Object object = this;
        synchronized (object) {
            this.state = RunnableInterface.State.IDLE;
        }
        object = this.barrier;
        synchronized (object) {
            if (state != RunnableInterface.State.IDLE) {
                this.interpreterRunnable.signalStopInterpreter();
                if (this.barrier.sleeping() > 0) {
                    this.barrier.waitBarrierIgnoreInterrupt("interpreter.stop");
                }
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    protected synchronized void executionDone() {
        this.state = RunnableInterface.State.IDLE;
        this.notify();
    }

    @Override
    public synchronized void addInterpreterListener(InterpreterListener interpreterListener) {
        this.listenerSupport.addInterpreterListener(interpreterListener);
    }

    @Override
    public synchronized void removeInterpreterListener(InterpreterListener interpreterListener) {
        this.listenerSupport.removeInterpreterListener(interpreterListener);
    }

    protected InterpreterListenerSupport getListenerSupport() {
        return this.listenerSupport;
    }

    @Override
    public void checkThreadState() {
    }
}

