/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorWindowListener;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.DelayedInitializer;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.TasksFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.ResourceAccessFactory;
import ch.karatojava.util.ResourceAccessInterface;
import ch.karatojava.util.XmlResourceAccess;
import ch.karatojava.util.gui.GreenMetalTheme;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class Application {
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected InterpreterFacadeInterface interpreterFacade;
    protected TasksFacadeInterface tasksFacade;
    protected KaraGuiFactory karaGuiFactory;
    public static final String CONFIG_FILE_XML = "/kappsresources/kappsproperties.xml";
    public static final String kapps_IMAGE_DIRECTORY = "/kappsresources/icons/";
    protected JFrame applicationFrame;
    protected String[] parameters;
    protected static Application instance;

    public static Application getInstance() {
        return instance;
    }

    public Application() {
        instance = this;
    }

    public Component getApplicationFrame() {
        return this.applicationFrame;
    }

    public InterpreterFacadeInterface getInterpreterFacade() {
        return this.interpreterFacade;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public ProgramEditorFacadeInterface getProgramEditorFacade() {
        return this.programEditorFacade;
    }

    public TasksFacadeInterface getTasksFacade() {
        return this.tasksFacade;
    }

    public WorldEditorFacadeInterface getWorldEditorFacade() {
        return this.worldEditorFacade;
    }

    public boolean isParameter(String string) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!this.parameters[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void startApplication(String[] stringArray) {
        this.parameters = stringArray;
        System.setProperty("com.apple.hwaccel", "false");
        this.initConfiguration(new XmlResourceAccess(CONFIG_FILE_XML, Application.class));
        if (this.isParameter("exceptions")) {
            ExceptionActionListener.DEBUG = true;
        }
        Configuration.getInstance().setCurrentValue("karamodel", this.getKaraModel());
        Konfig.createInstance();
        this.applicationFrame = this.karaGuiFactory.createApplicationFrame(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.applicationFrame.addWindowListener(windowAdapter);
        this.initializeFacades(this.applicationFrame.getContentPane());
        this.applicationFrame = this.karaGuiFactory.createApplicationFrame(false);
        this.applicationFrame.setContentPane(this.karaGuiFactory.createApplicationPanel(this.worldEditorFacade, this.programEditorFacade, this.interpreterFacade, this.tasksFacade));
        this.applicationFrame.validate();
        this.applicationFrame.removeWindowListener(windowAdapter);
        this.applicationFrame.setIconImage(Configuration.getInstance().getImage("karamodel/$karamodel/frameicon"));
        EditorIoToolbar editorIoToolbar = this.worldEditorFacade.getWorldEditorIoToolbar();
        this.applicationFrame.setDefaultCloseOperation(0);
        this.applicationFrame.addWindowListener(new EditorWindowListener(true, editorIoToolbar, this.programEditorFacade.getProgramEditorIoToolbar()));
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                File file;
                if (stringArray[i].startsWith("world=")) {
                    file = new File(stringArray[i].substring(6, stringArray[i].length()));
                    this.worldEditorFacade.getWorldEditorIoToolbar().loadFile(file);
                    continue;
                }
                if (!stringArray[i].startsWith("program=")) continue;
                file = new File(stringArray[i].substring(8, stringArray[i].length()));
                this.programEditorFacade.getProgramEditorIoToolbar().loadFile(file);
                continue;
            }
            catch (Exception exception) {
                ExceptionActionListener.reportException(this.applicationFrame, "Parameter error", exception);
            }
        }
    }

    public void stopApplication() {
        this.applicationFrame.dispose();
        this.programEditorFacade.getProgramEditorGui().dispose();
    }

    private DelayedInitializer[] createApplicationInitializers() {
        try {
            Class<?> clazz = Class.forName(Configuration.getInstance().getString("karamodel/$karamodel/facades/worldeditorfacade"));
            this.worldEditorFacade = (WorldEditorFacadeInterface)clazz.newInstance();
            Class<?> clazz2 = Class.forName(Configuration.getInstance().getString("karamodel/$karamodel/facades/programeditorfacade"));
            this.programEditorFacade = (ProgramEditorFacadeInterface)clazz2.newInstance();
            this.programEditorFacade.setWorldEditorFacade(this.worldEditorFacade);
            Class<?> clazz3 = Class.forName(Configuration.getInstance().getString("karamodel/$karamodel/facades/interpreterfacade"));
            this.interpreterFacade = (InterpreterFacadeInterface)clazz3.newInstance();
            this.interpreterFacade.setEditorFacades(this.worldEditorFacade, this.programEditorFacade);
            Class<?> clazz4 = Class.forName(Configuration.getInstance().getString("karamodel/$karamodel/facades/tasksfacade"));
            this.tasksFacade = (TasksFacadeInterface)clazz4.newInstance();
            this.tasksFacade.setFacades(this.worldEditorFacade, this.programEditorFacade, this.interpreterFacade);
            return new DelayedInitializer[]{this.worldEditorFacade, this.programEditorFacade, this.interpreterFacade, this.tasksFacade};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Application.createApplicationInitializers: exception occurred. \nclass: " + exception.getClass() + "\nmessage: " + exception.getMessage());
        }
    }

    private void initConfiguration(ResourceAccessInterface resourceAccessInterface) {
        ResourceAccessFactory.createFactory(resourceAccessInterface);
        Configuration.createInstance(kapps_IMAGE_DIRECTORY);
        GuiFactory.createInstance();
        this.createKaraGuiFactory();
        this.karaGuiFactory = KaraGuiFactory.getInstance();
        try {
            MetalLookAndFeel.setCurrentTheme(new GreenMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(new JPanel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Application.initConfiguration: could not create look and feel " + exception);
        }
    }

    private void initializeFacades(Container container) {
        DelayedInitializer[] delayedInitializerArray = this.createApplicationInitializers();
        int n = 0;
        for (int i = 0; i < delayedInitializerArray.length; ++i) {
            n += delayedInitializerArray[i].getNumberOfInitSteps();
        }
        JProgressBar jProgressBar = new JProgressBar(0, n);
        JLabel jLabel = new JLabel("creating ...");
        jLabel.setLabelFor(jProgressBar);
        container.setCursor(Cursor.getPredefinedCursor(3));
        KaraGuiFactory.getInstance().createStartupPanel(container, jProgressBar, jLabel);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = 0;
        for (int i = 0; i < delayedInitializerArray.length; ++i) {
            n2 = delayedInitializerArray[i].initialize(jProgressBar, jLabel, n2);
        }
        this.programEditorFacade.getProgramEditorGui().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RunnableInterface runnableInterface = Application.this.interpreterFacade.getInterpreter();
                if (runnableInterface.getState() != RunnableInterface.State.IDLE) {
                    runnableInterface.stop();
                }
            }
        });
    }

    protected void createKaraGuiFactory() {
        KaraGuiFactory.createInstance();
    }

    protected abstract String getKaraModel();
}

