/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps;

import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.gui.ContrastMetalTheme;
import ch.karatojava.util.gui.GreenMetalTheme;
import ch.karatojava.util.gui.SommerSkyMetalTheme;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class KaraConfigDialog
extends JDialog {
    protected static final long serialVersionUID = 784394098770041197L;
    protected Hashtable<String, MetalTheme> metalThemes;

    public KaraConfigDialog(Frame frame, WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface) {
        super(frame, false);
        this.setTitle(Configuration.getInstance().getString("language/$language/karaconfigdialog/title"));
        this.metalThemes = new Hashtable();
        this.metalThemes.put("sommersky", new SommerSkyMetalTheme());
        this.metalThemes.put("contrast", new ContrastMetalTheme());
        this.metalThemes.put("green", new GreenMetalTheme());
        this.createGUI(worldEditorFacadeInterface, programEditorFacadeInterface, interpreterFacadeInterface);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(frame);
    }

    protected void createGUI(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface) {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.createButtonPanel("color", "language/$language/karaconfigdialog/colors"));
        container.add(Box.createVerticalStrut(10));
        this.addConfigGui(container, worldEditorFacadeInterface.getConfigGui());
        this.addConfigGui(container, programEditorFacadeInterface.getConfigGui());
        this.addConfigGui(container, interpreterFacadeInterface.getConfigGui());
    }

    private JPanel createButtonPanel(String string, String string2) {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        return karaGuiFactory.createConfigurableRadioButtonPanel(new RadioButtonListener(string), string, string2);
    }

    private void addConfigGui(Container container, JComponent jComponent) {
        if (jComponent != null) {
            container.add(jComponent);
            container.add(Box.createVerticalStrut(10));
        }
    }

    protected class RadioButtonListener
    extends ExceptionActionListener {
        private String configurable;

        public RadioButtonListener(String string) {
            this.configurable = string;
        }

        @Override
        public void action(ActionEvent actionEvent) throws Exception {
            String string = actionEvent.getActionCommand();
            if (this.configurable.equals("color")) {
                try {
                    MetalLookAndFeel.setCurrentTheme(KaraConfigDialog.this.metalThemes.get(string));
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(KaraConfigDialog.this);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            Configuration.getInstance().setCurrentValue(this.configurable, string);
            KaraConfigDialog.this.repaint();
        }
    }
}

