/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorToolbarUiFactory;
import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;

public class KaraEditorUiFactory
extends EditorToolbarUiFactory {
    private JFileChooser fileChooser;
    private ExampleFileFilter filter;

    public KaraEditorUiFactory(JFileChooser jFileChooser, ExampleFileFilter exampleFileFilter) {
        this.fileChooser = jFileChooser;
        this.filter = exampleFileFilter;
    }

    @Override
    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public ExampleFileFilter getFileFilter() {
        return this.filter;
    }

    @Override
    public String getNotEnabledException(EditorIoToolbar.Command command) {
        return Configuration.getInstance().getString("language/$language/editor/notenabled");
    }

    @Override
    public TitledBorder createTitledBorder() {
        return GuiFactory.getInstance().createTitledBorder(null);
    }

    @Override
    public int askSave() {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.editorToolbar), Configuration.getInstance().getString("language/$language/editor/asksave"), Configuration.getInstance().getString("language/$language/editor/asksavetitle"), 1);
    }

    @Override
    public int askOverwrite(String string) {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.editorToolbar), Configuration.getInstance().getFormatString("language/$language/editor/askoverwrite", new String[]{string}), Configuration.getInstance().getString("language/$language/editor/askoverwritetitle"), 1);
    }

    @Override
    public void reportException(Exception exception) {
        ExceptionActionListener.reportException(this.editorToolbar, "", new Exception(Configuration.getInstance().getFormatString("language/$language/editor/fatalexception", new String[]{exception.getMessage()})));
    }

    @Override
    public JButton createButton(EditorIoToolbar.Command command) {
        if (command == EditorIoToolbar.Command.NEW) {
            return GuiFactory.getInstance().createImageIconButton("icons/new", "language/$language/editor/newtooltip");
        }
        if (command == EditorIoToolbar.Command.LOAD) {
            return GuiFactory.getInstance().createImageIconButton("icons/load", "language/$language/editor/loadtooltip");
        }
        if (command == EditorIoToolbar.Command.SAVE) {
            return GuiFactory.getInstance().createImageIconButton("icons/save", "language/$language/editor/savetooltip");
        }
        if (command == EditorIoToolbar.Command.SAVEAS) {
            return GuiFactory.getInstance().createImageIconButton("icons/saveas", "language/$language/editor/saveastooltip");
        }
        if (command == EditorIoToolbar.Command.RELOAD) {
            return GuiFactory.getInstance().createImageIconButton("icons/reload", "language/$language/editor/reloadtooltip");
        }
        return null;
    }

    public static class InterpreterListener
    extends InterpreterListenerAdapter {
        private EditorIoToolbar toolbar;

        public InterpreterListener(EditorIoToolbar editorIoToolbar) {
            assert (editorIoToolbar != null) : "KaraEditorUiFactory.InterpreterListener.constructor: toolbar == null";
            this.toolbar = editorIoToolbar;
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            this.toolbar.disableCommand(EditorIoToolbar.Command.NEW);
            this.toolbar.disableCommand(EditorIoToolbar.Command.LOAD);
            this.toolbar.disableCommand(EditorIoToolbar.Command.RELOAD);
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            this.toolbar.enableCommand(EditorIoToolbar.Command.NEW);
            this.toolbar.enableCommand(EditorIoToolbar.Command.LOAD);
            this.toolbar.enableCommand(EditorIoToolbar.Command.RELOAD);
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.stopped(runnableInterface);
        }
    }
}

