/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps;

import ch.karatojava.editor.EditorToolbarUiFactoryInterface;
import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiNorthPanel;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.TasksFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.legokaraide.LegoKaraGuiNorthPanel;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.JDirShareFileChooser;
import ch.karatojava.util.gui.FrameChangeListener;
import ch.karatojava.util.gui.HTMLEditorPane;
import ch.karatojava.util.gui.UISwitchListener;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class KaraGuiFactory {
    public static final String RADIO_BUTTON_PROPERTY = "radiobuttonproperty";
    protected static KaraGuiFactory instance;
    protected JFileChooser chooser;
    protected JDirShareFileChooser imageFileChooser;
    protected ExampleFileFilter turtleWorldFileFilter;
    protected ExampleFileFilter worldFileFilter;
    protected ExampleFileFilter programFileFilter;
    protected ExampleFileFilter javaSourceFileFilter;
    protected ExampleFileFilter javaScriptSourceFileFilter;
    protected ExampleFileFilter pythonSourceFileFilter;
    protected ExampleFileFilter logoSourceFileFilter;
    protected ExampleFileFilter rubySourceFileFilter;
    protected List<FrameChangeListener> frameChangeListeners = new ArrayList<FrameChangeListener>();
    protected JFrame applicationFrame;
    protected JFrame programEditorFrame;
    protected Configuration configuration = Configuration.getInstance();

    protected KaraGuiFactory() {
    }

    public void createStartupPanel(Container container, JProgressBar jProgressBar, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        JLabel jLabel2 = new JLabel(this.configuration.getImageIcon("karamodel/$karamodel/splash"));
        Dimension dimension = new Dimension(300, 30);
        jLabel2.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        jPanel.setOpaque(false);
        jLabel.setAlignmentX(0.5f);
        jLabel.setMaximumSize(dimension);
        jLabel.setPreferredSize(dimension);
        jLabel.setForeground(UIManager.getColor("ProgressBar.foreground"));
        jProgressBar.setStringPainted(true);
        jLabel.setLabelFor(jProgressBar);
        jProgressBar.setAlignmentX(0.5f);
        jProgressBar.setPreferredSize(dimension);
        jProgressBar.setForeground(UIManager.getColor("ProgressBar.foreground"));
        jProgressBar.setOpaque(false);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jLabel2);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jProgressBar);
        jPanel.add(Box.createVerticalStrut(10));
        container.add((Component)jPanel, "Center");
        container.validate();
    }

    public JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public JFrame createApplicationFrame(boolean bl) {
        int n;
        int n2;
        if (this.applicationFrame == null) {
            this.applicationFrame = new JFrame();
            this.createKaraFrameUi(this.applicationFrame, "language/$language/$karamodel/application_frametitle");
        }
        if (bl) {
            n2 = this.configuration.getInt("application/initialwidth");
            n = this.configuration.getInt("application/initialheight");
        } else {
            n2 = this.configuration.getInt("karamodel/$karamodel/appwidth");
            n = this.configuration.getInt("karamodel/$karamodel/appheight");
        }
        this.applicationFrame.getContentPane().removeAll();
        this.applicationFrame.setSize(n2, n);
        KaraGuiFactory.positionFrame(this.applicationFrame, 0.5f, 0.5f);
        this.applicationFrame.setVisible(true);
        return this.applicationFrame;
    }

    public JFrame getProgramEditorFrame() {
        return this.programEditorFrame;
    }

    public JFrame createProgramEditorFrame() {
        this.programEditorFrame = new JFrame();
        this.createKaraFrameUi(this.programEditorFrame, "language/$language/$karamodel/progeditor_frametitle");
        int n = this.configuration.getInt("karamodel/$karamodel/progeditorwidth");
        int n2 = this.configuration.getInt("karamodel/$karamodel/progeditorheight");
        this.programEditorFrame.setSize(n, n2);
        KaraGuiFactory.positionFrame(this.programEditorFrame, 0.0f, 0.5f);
        return this.programEditorFrame;
    }

    protected JPanel createNorthControlPanel(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface, TasksFacadeInterface tasksFacadeInterface) {
        String string = Configuration.getInstance().getCurrentValue("karamodel");
        if (string.equals("legokara")) {
            return new LegoKaraGuiNorthPanel(worldEditorFacadeInterface, programEditorFacadeInterface, interpreterFacadeInterface, tasksFacadeInterface);
        }
        return new KaraGuiNorthPanel(worldEditorFacadeInterface, programEditorFacadeInterface, interpreterFacadeInterface, tasksFacadeInterface);
    }

    public JPanel createApplicationPanel(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface, TasksFacadeInterface tasksFacadeInterface) {
        DndPanel dndPanel = new DndPanel();
        dndPanel.setLayout(new BorderLayout());
        if (this.configuration.getCurrentValue("karamodel").equalsIgnoreCase("multikara") || this.configuration.getCurrentValue("karamodel").equalsIgnoreCase("cora")) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.createNorthControlPanel(worldEditorFacadeInterface, programEditorFacadeInterface, interpreterFacadeInterface, tasksFacadeInterface), "Center");
            jPanel.add((Component)worldEditorFacadeInterface.getNorthPanel(), "South");
            dndPanel.add((Component)jPanel, "North");
        } else {
            dndPanel.add((Component)this.createNorthControlPanel(worldEditorFacadeInterface, programEditorFacadeInterface, interpreterFacadeInterface, tasksFacadeInterface), "North");
        }
        dndPanel.add((Component)worldEditorFacadeInterface.getWorldEditorGui(), "Center");
        dndPanel.add((Component)worldEditorFacadeInterface.getWorldEditorToolbar(), "East");
        dndPanel.add((Component)worldEditorFacadeInterface.getWestPanel(), "West");
        dndPanel.add((Component)interpreterFacadeInterface.getInterpreterToolbar(), "South");
        dndPanel.addThisMouseInputListenerToChildren();
        return dndPanel;
    }

    public JPanel createConfigurableRadioButtonPanel(ActionListener actionListener, String string, String string2) {
        List list = this.configuration.getPossibleValues(string);
        String string3 = this.configuration.getCurrentValue(string);
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>();
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder(string2));
        for (int i = 0; i < list.size(); ++i) {
            jPanel.add(Box.createHorizontalStrut(5));
            String string4 = (String)list.get(i);
            JRadioButton jRadioButton = this.createRadioButton(actionListener, string, string4, string4.equals(string3));
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            arrayList.add(jRadioButton);
        }
        jPanel.add(Box.createHorizontalGlue());
        jPanel.putClientProperty(RADIO_BUTTON_PROPERTY, arrayList);
        return jPanel;
    }

    public JRadioButton createRadioButton(ActionListener actionListener, String string, String string2, boolean bl) {
        String string3 = "metadata/" + string + "/icons/" + string2;
        String string4 = this.configuration.getString(string3);
        String string5 = "metadata/" + string + "/icons/" + string2 + "_unselected";
        String string6 = this.configuration.getString(string5);
        String string7 = this.configuration.getString("metadata/" + string + "/descriptions/" + string2);
        JRadioButton jRadioButton = new JRadioButton();
        if (!"".equals(string4) && !"".equals(string6)) {
            jRadioButton.setSelectedIcon(this.configuration.getImageIcon(string3));
            jRadioButton.setIcon(this.configuration.getImageIcon(string5));
            jRadioButton.setVerticalTextPosition(3);
            jRadioButton.setHorizontalTextPosition(0);
        }
        if (!string7.equals("")) {
            jRadioButton.setText(this.configuration.getString(string7));
        }
        if (bl) {
            jRadioButton.setSelected(true);
        }
        jRadioButton.setActionCommand(string2);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public ExampleFileFilter getJavaSourceFileFilter() {
        if (this.javaSourceFileFilter == null) {
            this.javaSourceFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/javafilesextension"), this.configuration.getString("karaguifactory/javafilesdescription"));
        }
        return this.javaSourceFileFilter;
    }

    public ExampleFileFilter getJavaScriptSourceFileFilter() {
        if (this.javaScriptSourceFileFilter == null) {
            this.javaScriptSourceFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/javascriptfilesextension"), this.configuration.getString("karaguifactory/javascriptfilesdescription"));
        }
        return this.javaScriptSourceFileFilter;
    }

    public ExampleFileFilter getPythonSourceFileFilter() {
        if (this.pythonSourceFileFilter == null) {
            this.pythonSourceFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/pythonfilesextension"), this.configuration.getString("karaguifactory/pythonfilesdescription"));
        }
        return this.pythonSourceFileFilter;
    }

    public ExampleFileFilter getLogoSourceFileFilter() {
        if (this.logoSourceFileFilter == null) {
            this.logoSourceFileFilter = new ExampleFileFilter("logo", "Logo Programs");
        }
        return this.logoSourceFileFilter;
    }

    public ExampleFileFilter getRubySourceFileFilter() {
        if (this.rubySourceFileFilter == null) {
            this.rubySourceFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/rubyfilesextension"), this.configuration.getString("karaguifactory/rubyfilesdescription"));
        }
        return this.rubySourceFileFilter;
    }

    public ExampleFileFilter getProgramFileFilter() {
        if (this.programFileFilter == null) {
            this.programFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/programfilesextension"), this.configuration.getString("karaguifactory/programfilesdescription"));
        }
        return this.programFileFilter;
    }

    public ExampleFileFilter getWorldFileFilter() {
        if (this.worldFileFilter == null) {
            this.worldFileFilter = new ExampleFileFilter(this.configuration.getString("karaguifactory/worldfilesextension"), this.configuration.getString("karaguifactory/worldfilesdescription"));
        }
        return this.worldFileFilter;
    }

    public ExampleFileFilter getTurtleWorldFileFilter() {
        if (this.turtleWorldFileFilter == null) {
            this.turtleWorldFileFilter = new ExampleFileFilter("turtleworld", "Turtle World");
        }
        return this.turtleWorldFileFilter;
    }

    public JDirShareFileChooser getImageExportFileChooser() {
        JDirShareFileChooser jDirShareFileChooser = this.imageFileChooser;
        this.imageFileChooser = new JDirShareFileChooser();
        if (jDirShareFileChooser != null) {
            jDirShareFileChooser.addSharePartner(this.imageFileChooser);
        }
        this.imageFileChooser.setMultiSelectionEnabled(false);
        this.imageFileChooser.addChoosableFileFilter(new ExampleFileFilter("jpg"));
        this.imageFileChooser.setApproveButtonText("Save");
        GuiFactory.getInstance().addUiSwitchListener(this.imageFileChooser);
        return this.imageFileChooser;
    }

    public JFileChooser getFileChooser() {
        JDirShareFileChooser jDirShareFileChooser = (JDirShareFileChooser)this.chooser;
        this.chooser = new JDirShareFileChooser();
        this.chooser.setMultiSelectionEnabled(false);
        if (jDirShareFileChooser != null) {
            jDirShareFileChooser.addSharePartner((JDirShareFileChooser)this.chooser);
        }
        GuiFactory.getInstance().addUiSwitchListener(this.chooser);
        return this.chooser;
    }

    public EditorToolbarUiFactoryInterface createEditorToolbar(JFileChooser jFileChooser, ExampleFileFilter exampleFileFilter) {
        return new KaraEditorUiFactory(jFileChooser, exampleFileFilter);
    }

    public void createKaraFrameUi(JFrame jFrame, String string) {
        if (string != null) {
            jFrame.setTitle(this.configuration.getString(string));
        }
        jFrame.setIconImage(this.configuration.getImage("karamodel/$karamodel/frameicon"));
        UIManager.addPropertyChangeListener(new UISwitchListener(jFrame.getRootPane()));
        FrameChangeListener frameChangeListener = new FrameChangeListener(jFrame);
        this.frameChangeListeners.add(frameChangeListener);
        this.configuration.addPropertyChangeListener(frameChangeListener, true);
    }

    public static void positionFrame(JFrame jFrame, float f, float f2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = jFrame.getWidth();
        int n2 = jFrame.getHeight();
        int n3 = (int)(f * (float)(dimension.width - n));
        int n4 = (int)(f2 * (float)(dimension.height - n2));
        jFrame.setLocation(n3, n4);
    }

    public JFrame createHelpFrame() {
        final HTMLEditorPane hTMLEditorPane = new HTMLEditorPane("language/$language/helpfile/$karamodel");
        JFrame jFrame = new JFrame(){
            private static final long serialVersionUID = -5960750161626749015L;

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (bl) {
                    hTMLEditorPane.showFile("language/$language/helpfile/$karamodel");
                }
            }
        };
        this.createKaraFrameUi(jFrame, "language/$language/helpframetitle");
        JScrollPane jScrollPane = new JScrollPane(hTMLEditorPane);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jScrollPane, "Center");
        jFrame.setContentPane(jScrollPane);
        jFrame.setSize(this.configuration.getInt("helpframe/width"), this.configuration.getInt("helpframe/height"));
        KaraGuiFactory.positionFrame(jFrame, 0.5f, 0.5f);
        jFrame.setDefaultCloseOperation(1);
        return jFrame;
    }

    public static void createInstance() {
        instance = new KaraGuiFactory();
    }

    public static KaraGuiFactory getInstance() {
        return instance;
    }
}

