/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.AbstractEditor;
import ch.karatojava.editor.DocumentToEditorListenerAdapter;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.abstractscriptide.ErrorMessage;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;

public abstract class AbstractScriptEditor
extends AbstractEditor {
    protected static final ErrorMessage[] NO_MESSAGE = new ErrorMessage[0];
    protected static final Color MESSAGES_COLOR = new Color(255, 150, 150);
    protected static final Color COMPILE_ERROR_COLOR = new Color(220, 200, 200);
    protected static final Font FONT = new Font("DialogInput", 0, 12);
    protected static final int BUFFER_SIZE = 2048;
    protected JPanel editorPanel;
    protected EditorIoToolbar editorToolbar;
    protected JEditorPane sourceTextEditorPane;
    protected JList errorMessagesList;
    protected DocumentToEditorListenerAdapter editorAdapter;
    protected InterpreterListener interpreterListener = new InterpreterListenerAdapter(){
        protected boolean isEditable = true;
        protected MouseAdapter dummyMouse = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ExceptionActionListener.reportException(AbstractScriptEditor.this.editorPanel, Configuration.getInstance().getString("language/$language/scriptide/dontmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/scriptide/dontmodify")));
            }
        };

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.setEditable(true);
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            this.setEditable(false);
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            this.setEditable(true);
        }

        protected void setEditable(boolean bl) {
            JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(AbstractScriptEditor.this.editorPanel);
            Component component = jFrame.getGlassPane();
            if (!bl && this.isEditable) {
                component.addMouseListener(this.dummyMouse);
                component.setVisible(true);
            } else if (bl && !this.isEditable) {
                component.setVisible(false);
                component.removeMouseListener(this.dummyMouse);
            }
            AbstractScriptEditor.this.sourceTextEditorPane.setEditable(bl);
            this.isEditable = bl;
        }
    };
    protected ListSelectionListener messageListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2 = AbstractScriptEditor.this.errorMessagesList.getSelectedIndex();
            if (n2 >= 0 && (n = ((ErrorMessage)AbstractScriptEditor.this.errorMessagesList.getModel().getElementAt(n2)).getLineNumber()) >= 0) {
                String string = AbstractScriptEditor.this.sourceTextEditorPane.getText();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < n && n5 < string.length(); ++i) {
                    n3 = n4;
                    while (n5 < string.length() && string.charAt(n5) != '\n') {
                        ++n5;
                    }
                    n4 = n5++;
                }
                AbstractScriptEditor.this.sourceTextEditorPane.requestFocus();
                if (n3 <= string.length() - 1) {
                    AbstractScriptEditor.this.sourceTextEditorPane.setCaretPosition(n3);
                    AbstractScriptEditor.this.sourceTextEditorPane.setSelectionStart(n3 + 1);
                    AbstractScriptEditor.this.sourceTextEditorPane.setSelectionEnd(n4 < string.length() - 1 ? n4 + 1 : n4);
                }
            }
        }
    };

    public AbstractScriptEditor() {
        this.editorPanel = new JPanel();
        this.editorAdapter = new DocumentToEditorListenerAdapter(this.listenerSupport);
        this.editorToolbar = this.createEditorToolbar();
        JSplitPane jSplitPane = new JSplitPane(0);
        DefaultSyntaxKit.initKit();
        this.sourceTextEditorPane = new JEditorPane();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        this.errorMessagesList = new JList();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        jToolBar.setFocusable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.editorToolbar, "North");
        jPanel2.add((Component)jToolBar, "South");
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)jPanel2, "North");
        this.editorPanel.add((Component)jSplitPane, "Center");
        jSplitPane.setTopComponent(new JScrollPane(this.sourceTextEditorPane));
        jSplitPane.setBottomComponent(new JScrollPane(jPanel));
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(400);
        this.sourceTextEditorPane.setContentType(this.getMimeType());
        this.sourceTextEditorPane.getDocument().addDocumentListener(this.editorAdapter);
        jToolBar.validate();
        this.newFile();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "North");
        jPanel.add((Component)new JScrollPane(this.errorMessagesList), "Center");
        this.initializeCompileButton(jButton);
        this.errorMessagesList.setCellRenderer(new MessageListRenderer());
        this.errorMessagesList.addListSelectionListener(this.messageListener);
        this.errorMessagesList.setBackground(COMPILE_ERROR_COLOR);
        this.errorMessagesList.setListData(NO_MESSAGE);
    }

    @Override
    public Object create(InputStream inputStream) throws Exception {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray, 0, 2048)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        inputStreamReader.close();
        return stringBuffer.toString();
    }

    @Override
    public Object getContent() {
        if (!JOptionPane.getFrameForComponent(this.editorPanel).isVisible()) {
            throw new RuntimeException(Configuration.getInstance().getString("language/$language/interpreter/progwinclosed"));
        }
        try {
            if (!this.editorToolbar.saveFile()) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        return this.sourceTextEditorPane.getText();
    }

    public EditorIoToolbar getEditorToolbar() {
        return this.editorToolbar;
    }

    public JPanel getGui() {
        return this.editorPanel;
    }

    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    @Override
    public boolean isModified() {
        return this.editorAdapter.isModified();
    }

    public void loadExecutable(String string) throws Exception {
        this.editorAdapter.resetModified();
    }

    public void resetErrorMessages() {
        this.errorMessagesList.setOpaque(false);
        this.errorMessagesList.setListData(NO_MESSAGE);
    }

    public void setFontSize(int n) {
        Font font = this.sourceTextEditorPane.getFont();
        font = font.deriveFont(font.getStyle(), n);
        this.sourceTextEditorPane.setFont(font);
    }

    public void setMessagesArray(ErrorMessage[] errorMessageArray) {
        this.errorMessagesList.setListData(errorMessageArray);
        this.errorMessagesList.setOpaque(errorMessageArray != null && errorMessageArray.length > 0);
        this.errorMessagesList.setEnabled(errorMessageArray != null && errorMessageArray.length > 0);
    }

    protected abstract EditorIoToolbar createEditorToolbar();

    @Override
    protected void doNewFile() {
        SyntaxDocument syntaxDocument = (SyntaxDocument)this.sourceTextEditorPane.getDocument();
        this.sourceTextEditorPane.setText(this.getTemplate());
        this.sourceTextEditorPane.setCaretPosition(0);
        syntaxDocument.clearUndos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(outputStream);
            printWriter.print(this.sourceTextEditorPane.getText());
            this.resetErrorMessages();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    @Override
    protected void doSetContent(Object object) {
        SyntaxDocument syntaxDocument = (SyntaxDocument)this.sourceTextEditorPane.getDocument();
        this.sourceTextEditorPane.setText(object.toString());
        this.sourceTextEditorPane.setCaretPosition(0);
        syntaxDocument.clearUndos();
    }

    protected abstract String getFileExtension();

    protected abstract String getMimeType();

    protected String getTemplate() {
        return Configuration.getInstance().getString("language/$language/$karamodel/template");
    }

    protected void initializeCompileButton(JButton jButton) {
    }

    @Override
    protected void resetModified() {
        this.resetErrorMessages();
        this.editorAdapter.resetModified();
    }

    protected class MessageListRenderer
    extends JTextArea
    implements ListCellRenderer {
        private static final long serialVersionUID = -6313817226464992907L;

        public MessageListRenderer() {
            this.setFont(FONT);
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            if (bl) {
                this.setOpaque(true);
                this.setBackground(MESSAGES_COLOR);
            } else {
                this.setOpaque(false);
            }
            return this;
        }
    }
}

