/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerSupport;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.abstractscriptide.AbstractScriptEditor;
import ch.karatojava.kapps.abstractscriptide.ScriptException;

public abstract class AbstractScriptInterpreter
implements RunnableInterface {
    protected Runnable interpreterRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (AbstractScriptInterpreter.this.executable != null) : "JavaKaraInterpreter.interpreterRunnable.run: program == null";
            try {
                AbstractScriptInterpreter.this.execute(AbstractScriptInterpreter.this.executable);
                Thread.sleep(20L);
                if (AbstractScriptInterpreter.this.state != RunnableInterface.State.IDLE) {
                    AbstractScriptInterpreter.this.stop();
                }
            }
            catch (StopException stopException) {
                AbstractScriptInterpreter.this.listenerSupport.fireStopped();
            }
            catch (ScriptException scriptException) {
                scriptException.printStackTrace();
                AbstractScriptInterpreter.this.exceptionHandler.handleException(scriptException);
                AbstractScriptInterpreter.this.state = RunnableInterface.State.IDLE;
                AbstractScriptInterpreter.this.stopInterpreter = true;
                AbstractScriptInterpreter abstractScriptInterpreter = AbstractScriptInterpreter.this;
                synchronized (abstractScriptInterpreter) {
                    AbstractScriptInterpreter.this.notify();
                }
                ((AbstractScriptEditor)AbstractScriptInterpreter.this.programEditor).setMessagesArray(scriptException.getMessages());
                AbstractScriptInterpreter.this.listenerSupport.fireErrorStop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AbstractScriptInterpreter.this.exceptionHandler.handleException(exception);
                AbstractScriptInterpreter.this.state = RunnableInterface.State.IDLE;
                AbstractScriptInterpreter.this.stopInterpreter = true;
                AbstractScriptInterpreter abstractScriptInterpreter = AbstractScriptInterpreter.this;
                synchronized (abstractScriptInterpreter) {
                    AbstractScriptInterpreter.this.notify();
                }
                AbstractScriptInterpreter.this.listenerSupport.fireErrorStop();
            }
        }
    };
    protected RunnableInterface.State state;
    protected InterpreterListenerSupport listenerSupport = new InterpreterListenerSupport(this);
    protected ExceptionHandler exceptionHandler;
    protected EditorInterface programEditor;
    protected EditorInterface worldEditor;
    protected Object executable;
    protected boolean pauseInterpreter;
    protected boolean stopInterpreter = true;
    protected int waitInterval = 0;

    protected abstract void execute(Object var1) throws ScriptException;

    public AbstractScriptInterpreter() {
        this.state = RunnableInterface.State.IDLE;
    }

    public void setProgramEditor(EditorInterface editorInterface) {
        assert (editorInterface != null);
        this.programEditor = editorInterface;
    }

    public void setWorldEditor(EditorInterface editorInterface) {
        assert (editorInterface != null);
        this.worldEditor = editorInterface;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        assert (exceptionHandler != null);
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setWaitInterval(int n) {
        assert (n >= 0);
        this.waitInterval = n;
    }

    @Override
    public RunnableInterface.State getState() {
        return this.state;
    }

    @Override
    public int getWaitInterval() {
        return this.waitInterval;
    }

    protected abstract void checkExecutable(Object var1);

    protected abstract void initializeExecutable(Object var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void play() throws InterpreterException {
        assert (this.state != RunnableInterface.State.RUNNING) : "JavaKaraInterpreter.play: already RUNNING";
        assert (this.exceptionHandler != null) : "JavaKaraInterpreter.play: exceptionHandler == null";
        if (this.state == RunnableInterface.State.IDLE) {
            try {
                this.executable = this.programEditor.getContent();
                this.checkExecutable(this.executable);
            }
            catch (RuntimeException runtimeException) {
                this.listenerSupport.fireErrorStop();
                throw runtimeException;
            }
            if (this.executable == null) {
                this.listenerSupport.fireErrorStop();
                return;
            }
            this.initializeExecutable(this.executable);
            this.pauseInterpreter = false;
            this.stopInterpreter = false;
            new Thread(this.interpreterRunnable).start();
            this.listenerSupport.fireGotReady();
        } else if (this.state == RunnableInterface.State.PAUSING) {
            this.pauseInterpreter = false;
            this.notifyAll();
        } else assert (false) : "JavaKaraInterpreter.play: illegal state";
        this.state = RunnableInterface.State.RUNNING;
        this.listenerSupport.firePlaying();
    }

    @Override
    public synchronized void pause() {
        assert (this.state == RunnableInterface.State.RUNNING) : "JavaKaraInterpreter.pause: not running.";
        this.pauseInterpreter = true;
        this.state = RunnableInterface.State.PAUSING;
        this.listenerSupport.firePausing();
    }

    @Override
    public synchronized void stop() {
        assert (this.state != RunnableInterface.State.IDLE) : "JavaKaraInterpreter.stop: not running.";
        this.stopInterpreter = true;
        this.notify();
        this.state = RunnableInterface.State.IDLE;
        this.listenerSupport.fireStopped();
    }

    @Override
    public synchronized void addInterpreterListener(InterpreterListener interpreterListener) {
        this.listenerSupport.addInterpreterListener(interpreterListener);
    }

    @Override
    public synchronized void removeInterpreterListener(InterpreterListener interpreterListener) {
        this.listenerSupport.removeInterpreterListener(interpreterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkThreadState() {
        block8: {
            try {
                if (this.pauseInterpreter) {
                    AbstractScriptInterpreter abstractScriptInterpreter = this;
                    synchronized (abstractScriptInterpreter) {
                        while (this.pauseInterpreter && !this.stopInterpreter) {
                            this.wait();
                        }
                        break block8;
                    }
                }
                Thread.sleep(this.waitInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.stopInterpreter) {
            throw new StopException();
        }
    }

    public static class StopException
    extends RuntimeException {
        protected static final long serialVersionUID = 1L;
    }
}

