/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import java.io.File;
import java.io.FileInputStream;

class FileClassLoader
extends ClassLoader {
    protected String directory;

    public FileClassLoader(File file) {
        this.directory = file.getParent();
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        FileInputStream fileInputStream = null;
        try {
            if (!string.endsWith(".class")) {
                string = this.directory + File.separator + string + ".class";
            }
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length);
            return clazz;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(string);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

