/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.kapps.abstractscriptide.ErrorMessage;
import ch.karatojava.kapps.abstractscriptide.FileClassLoader;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.StreamGobbler;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class JavaCompiler {
    protected static final boolean OS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    protected ErrorMessage[] messagesArray;
    protected String javacPath;
    protected String compilerCommand;

    public JavaCompiler() {
        this.setJavacPath("");
        this.compilerCommand = "";
    }

    public void setJavacPath(String string) {
        assert (string != null);
        this.javacPath = string;
    }

    protected String getSystemFileName(String string) {
        if (OS_WINDOWS) {
            return "\"" + string + "\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                stringBuffer.append("\\");
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    protected String getClassPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-classpath ");
        if (OS_WINDOWS) {
            stringBuffer.append("\"");
        }
        File file = new File(System.getProperty("java.class.path"));
        stringBuffer.append(file.getAbsolutePath());
        if (OS_WINDOWS) {
            stringBuffer.append(";");
        } else {
            stringBuffer.append(":");
        }
        stringBuffer.append(string);
        stringBuffer.append(";");
        if (OS_WINDOWS) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    protected int findLineNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = -1;
        while (n < 0 && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    protected ErrorMessage[] splitMessage(String string) {
        ErrorMessage[] errorMessageArray;
        ArrayList<ErrorMessage> arrayList = new ArrayList<ErrorMessage>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        ErrorMessage errorMessage = null;
        while (stringTokenizer.hasMoreTokens()) {
            errorMessageArray = stringTokenizer.nextToken();
            int n = this.findLineNumber((String)errorMessageArray);
            if (n >= 0) {
                if (errorMessage != null) {
                    errorMessage.message = stringBuffer.toString();
                    if (!errorMessage.message.equals("")) {
                        arrayList.add(errorMessage);
                    }
                }
                errorMessage = new ErrorMessage();
                errorMessage.lineNumber = n;
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append((String)errorMessageArray);
            stringBuffer.append("\n");
        }
        if (!stringBuffer.equals("")) {
            if (errorMessage == null) {
                errorMessage = new ErrorMessage();
                errorMessage.lineNumber = -1;
            }
            errorMessage.message = stringBuffer.toString();
            if (!errorMessage.message.equals("")) {
                arrayList.add(errorMessage);
            }
        }
        errorMessageArray = new ErrorMessage[arrayList.size()];
        return arrayList.toArray(errorMessageArray);
    }

    protected String executeCompiler(String string, String string2) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        this.compilerCommand = string + " " + string2;
        Process process = runtime.exec(this.compilerCommand);
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
        streamGobbler.start();
        streamGobbler2.start();
        streamGobbler.join();
        streamGobbler2.join();
        process.waitFor();
        return streamGobbler.getMessage() + streamGobbler2.getMessage();
    }

    public String getCompilerCommand() {
        return this.compilerCommand;
    }

    public void compile(File file) throws Exception {
        try {
            assert (file != null) : "JavaCompiler.compile: source == null";
            String string = this.getClassPath(file.getParent());
            String string2 = this.executeCompiler(this.javacPath + " " + string + " ", this.getSystemFileName(file.getAbsolutePath()));
            this.messagesArray = this.splitMessage(string2);
        }
        catch (Exception exception) {
            throw new Exception(Configuration.getInstance().getFormatString("language/$language/scriptide/cannotcompile", new String[]{exception.getClass().getName() + "\n" + exception.getMessage()}));
        }
    }

    public ErrorMessage[] getCompilerMessages() {
        return this.messagesArray;
    }

    public Object loadJavaProgram(File file) {
        String string = file.getAbsolutePath();
        assert (string.endsWith(".java")) : "JavaCompiler.compileAndLoad: file extension not .java";
        string = string.substring(0, string.length() - 5);
        string = string + ".class";
        try {
            FileClassLoader fileClassLoader = new FileClassLoader(new File(string));
            Class<?> clazz = fileClassLoader.loadClass(string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            throw new RuntimeException(Configuration.getInstance().getFormatString("language/$language/scriptide/cannotcompile", new String[]{exception.getClass().getName() + "\n" + exception.getMessage()}));
        }
    }
}

