/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.abstractscriptide.AbstractScriptEditor;
import ch.karatojava.kapps.abstractscriptide.ErrorMessage;
import ch.karatojava.kapps.abstractscriptide.JavaCompiler;
import ch.karatojava.kapps.tasks.ExecutableLoaderInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.io.File;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class JavaEditor
extends AbstractScriptEditor
implements ExecutableLoaderInterface {
    protected boolean mustRecompile;
    protected JavaCompiler compiler;
    protected Object executable;

    public JavaEditor(JavaCompiler javaCompiler) {
        this.compiler = javaCompiler;
    }

    public boolean compile() throws Exception {
        boolean bl;
        boolean bl2 = bl = !this.mustRecompile && !this.editorAdapter.isModified();
        if (!bl) {
            this.editorAdapter.insertUpdate(null);
            this.listenerSupport.fireModifiedContent();
            this.executable = null;
            if (this.editorToolbar.saveFile()) {
                File file = this.getCurrentFile();
                this.compiler.compile(file);
                ErrorMessage[] errorMessageArray = this.compiler.getCompilerMessages();
                ErrorMessage[] errorMessageArray2 = new ErrorMessage[errorMessageArray.length + 1];
                System.arraycopy(errorMessageArray, 0, errorMessageArray2, 1, errorMessageArray.length);
                errorMessageArray2[0] = new ErrorMessage("Executed: " + this.compiler.getCompilerCommand() + "\n", -1);
                this.errorMessagesList.setListData(errorMessageArray2);
                this.mustRecompile = errorMessageArray.length > 0;
                this.errorMessagesList.setOpaque(this.mustRecompile);
                this.errorMessagesList.setEnabled(this.mustRecompile);
                bl = !this.mustRecompile;
            }
        }
        return bl;
    }

    @Override
    public Object getContent() {
        if (!JOptionPane.getFrameForComponent(this.editorPanel).isVisible()) {
            throw new RuntimeException(Configuration.getInstance().getString("language/$language/interpreter/progwinclosed"));
        }
        Object object = null;
        try {
            if (this.executable != null && !this.editorAdapter.isModified()) {
                return this.executable;
            }
            boolean bl = this.compile();
            if (bl && this.compiler.getCompilerMessages().length == 0) {
                object = this.compiler.loadJavaProgram(this.getCurrentFile());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        return object;
    }

    @Override
    public void loadExecutable(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        this.executable = clazz.newInstance();
        this.mustRecompile = false;
        this.editorAdapter.resetModified();
    }

    @Override
    public void save(File file) throws Exception {
        boolean bl = file != this.currentFile;
        boolean bl2 = this.editorAdapter.isModified();
        super.save(file);
        if (bl || bl2) {
            this.mustRecompile = true;
        }
    }

    @Override
    protected EditorIoToolbar createEditorToolbar() {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        return new EditorIoToolbar(this, karaGuiFactory.createEditorToolbar(karaGuiFactory.getFileChooser(), karaGuiFactory.getJavaSourceFileFilter()), this.getFileExtension());
    }

    @Override
    protected void doNewFile() {
        super.doNewFile();
        this.mustRecompile = true;
        this.executable = null;
    }

    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        super.doSave(outputStream);
        this.executable = null;
    }

    @Override
    protected void doSetContent(Object object) {
        super.doSetContent(object);
        this.mustRecompile = true;
        this.executable = null;
    }

    @Override
    protected String getFileExtension() {
        return "java";
    }

    @Override
    protected String getMimeType() {
        return "text/java";
    }

    @Override
    protected void initializeCompileButton(JButton jButton) {
        jButton.addActionListener(new ExceptionActionListener(this, "compile"));
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), jButton.getBorder()));
        jButton.setText(Configuration.getInstance().getString("language/$language/scriptide/compilebutton"));
        jButton.setHorizontalAlignment(2);
    }
}

