/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import javax.swing.JOptionPane;

public class ScriptTools {
    private RunnableInterface interpreter;

    public void setInterpreter(RunnableInterface runnableInterface) {
        this.interpreter = runnableInterface;
    }

    public void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkState() {
        this.interpreter.checkThreadState();
    }

    public void println(String string) {
        System.out.println(string);
    }

    public int random(int n) {
        return (int)(Math.random() * (double)(n + 1));
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(KaraGuiFactory.getInstance().getApplicationFrame(), string, Configuration.getInstance().getString("language/$language/scriptide/tools/showmsg"), 1);
    }

    public String stringInput(String string) {
        return JOptionPane.showInputDialog(KaraGuiFactory.getInstance().getApplicationFrame(), (Object)string);
    }

    public int intInput(String string) {
        int n = 0;
        String string2 = JOptionPane.showInputDialog(KaraGuiFactory.getInstance().getApplicationFrame(), (Object)string);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.MIN_VALUE;
            ExceptionActionListener.reportException(KaraGuiFactory.getInstance().getApplicationFrame(), "", new Exception(Configuration.getInstance().getFormatString("language/$language/scriptide/tools/notanumber", new String[]{numberFormatException.getMessage(), "" + n})));
        }
        return n;
    }

    public double doubleInput(String string) {
        double d = 0.0;
        String string2 = JOptionPane.showInputDialog(KaraGuiFactory.getInstance().getApplicationFrame(), (Object)string);
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.MIN_VALUE;
            ExceptionActionListener.reportException(KaraGuiFactory.getInstance().getApplicationFrame(), "", new Exception(Configuration.getInstance().getFormatString("language/$language/scriptide/tools/notanumber", new String[]{numberFormatException.getMessage(), "" + d})));
        }
        return d;
    }
}

