/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractturtleide;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraInterpreterUiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public abstract class AbstractScriptTurtleInterpreterFacade
implements InterpreterFacadeInterface {
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected RunnableInterface interpreter;
    protected JPanel toolbar;

    @Override
    public void setEditorFacades(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface) {
        assert (worldEditorFacadeInterface != null);
        assert (programEditorFacadeInterface != null);
        this.worldEditorFacade = worldEditorFacadeInterface;
        this.programEditorFacade = programEditorFacadeInterface;
    }

    @Override
    public int getNumberOfInitSteps() {
        return 3;
    }

    @Override
    public JComponent getInterpreterToolbar() {
        return this.toolbar;
    }

    @Override
    public RunnableInterface getInterpreter() {
        return this.interpreter;
    }

    @Override
    public JComponent getConfigGui() {
        return null;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        int n2;
        jLabel.setText("creating java interpreter editor ...");
        this.interpreter = this.createInterpreter();
        jProgressBar.setValue(++n);
        jLabel.setText("creating interpreter toolbar...");
        this.toolbar = this.createToolbar(this.interpreter);
        jProgressBar.setValue(++n);
        jLabel.setText("hooking up interpreter listeners...");
        InterpreterListener[] interpreterListenerArray = this.worldEditorFacade.getInterpreterListeners();
        for (n2 = 0; n2 < interpreterListenerArray.length; ++n2) {
            this.getInterpreter().addInterpreterListener(interpreterListenerArray[n2]);
        }
        interpreterListenerArray = this.programEditorFacade.getInterpreterListeners();
        for (n2 = 0; n2 < interpreterListenerArray.length; ++n2) {
            this.getInterpreter().addInterpreterListener(interpreterListenerArray[n2]);
        }
        jProgressBar.setValue(++n);
        return n;
    }

    protected abstract RunnableInterface createInterpreter();

    protected JPanel createToolbar(RunnableInterface runnableInterface) {
        return new InterpreterToolbar(new KaraInterpreterUiFactory(), runnableInterface);
    }
}

