/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractturtleide;

import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.turtleworld.Turtle;
import ch.karatojava.kapps.turtleworld.TurtleWorld;
import java.util.Stack;

public class TurtleWrapper {
    protected RunnableInterface interpreter;
    protected Turtle turtle;
    protected Stack<TurtleWrapper> turtleStates;

    public TurtleWrapper(Turtle turtle, RunnableInterface runnableInterface) {
        this.turtle = turtle;
        this.interpreter = runnableInterface;
        this.turtleStates = new Stack();
    }

    public double getDirection() {
        return this.turtle.getDirection();
    }

    public void setDirection(double d) {
        this.turtle.setDirection(d);
        this.interpreter.checkThreadState();
    }

    public double getX() {
        return this.turtle.getX();
    }

    public void setX(double d) {
        this.turtle.setX(d);
        this.interpreter.checkThreadState();
    }

    public double getY() {
        return this.turtle.getY();
    }

    public void setY(double d) {
        this.turtle.setY(d);
        this.interpreter.checkThreadState();
    }

    public void setPosition(double d, double d2) {
        this.turtle.setX(d);
        this.turtle.setY(d2);
        this.interpreter.checkThreadState();
    }

    public boolean isPenDown() {
        return this.turtle.isPenDown();
    }

    public void setPenDown(boolean bl) {
        this.turtle.setPenDown(bl);
        this.interpreter.checkThreadState();
    }

    public void penUp() {
        this.turtle.penUp();
        this.interpreter.checkThreadState();
    }

    public void penDown() {
        this.turtle.penDown();
        this.interpreter.checkThreadState();
    }

    public boolean isXor() {
        return this.turtle.isXor();
    }

    public void setXor(boolean bl) {
        this.turtle.setXor(bl);
        this.interpreter.checkThreadState();
    }

    public void show() {
        this.turtle.setVisible(true);
    }

    public void hide() {
        this.turtle.setVisible(false);
    }

    public boolean isVisible() {
        return this.turtle.isVisible();
    }

    public void setVisible(boolean bl) {
        this.turtle.setVisible(bl);
    }

    public void setColor(int n, int n2, int n3) {
        this.turtle.setColor(n, n2, n3);
    }

    public int getColorRed() {
        return this.turtle.getColorRed();
    }

    public int getColorGreen() {
        return this.turtle.getColorGreen();
    }

    public int getColorBlue() {
        return this.turtle.getColorBlue();
    }

    public int getPenWidth() {
        return this.turtle.getPenWidth();
    }

    public void setPenWidth(int n) {
        this.turtle.setPenWidth(n);
    }

    public void moveto(double d, double d2) {
        this.turtle.moveto(d, d2);
        this.interpreter.checkThreadState();
    }

    public void forward(double d) {
        this.turtle.forward(d);
        this.interpreter.checkThreadState();
    }

    public void turn(double d) {
        this.turtle.turn(d);
        this.interpreter.checkThreadState();
    }

    public void back(double d) {
        this.turtle.turn(180.0);
        this.turtle.forward(d);
        this.turtle.turn(180.0);
    }

    public void clearWorld() {
        TurtleWorld turtleWorld = this.turtle.getTurtleWorld();
        turtleWorld.clear();
        this.turtle = turtleWorld.getTurtles().get(0);
        this.interpreter.checkThreadState();
    }

    public TurtleWrapper clone() {
        TurtleWrapper turtleWrapper = new TurtleWrapper(this.turtle.getTurtleWorld().addTurtle(), this.interpreter);
        turtleWrapper.setColor(this.turtle.getColorRed(), this.turtle.getColorGreen(), this.turtle.getColorBlue());
        turtleWrapper.setDirection(this.turtle.getDirection());
        turtleWrapper.setPenDown(this.turtle.isPenDown());
        turtleWrapper.setPenWidth(this.turtle.getPenWidth());
        turtleWrapper.setPosition(this.turtle.getX(), this.turtle.getY());
        turtleWrapper.setVisible(this.turtle.isVisible());
        turtleWrapper.setXor(this.turtle.isXor());
        return turtleWrapper;
    }

    public void remember() {
        TurtleWrapper turtleWrapper = new TurtleWrapper(new Turtle(this.turtle.getTurtleWorld()), this.interpreter);
        turtleWrapper.setColor(this.turtle.getColorRed(), this.turtle.getColorGreen(), this.turtle.getColorBlue());
        turtleWrapper.setDirection(this.turtle.getDirection());
        turtleWrapper.setPenDown(this.turtle.isPenDown());
        turtleWrapper.setVisible(this.turtle.isVisible());
        turtleWrapper.setPenWidth(this.turtle.getPenWidth());
        turtleWrapper.setPosition(this.turtle.getX(), this.turtle.getY());
        turtleWrapper.setXor(this.turtle.isXor());
        this.turtleStates.push(turtleWrapper);
    }

    public void recall() {
        TurtleWrapper turtleWrapper = this.turtleStates.pop();
        this.turtle.setColor(turtleWrapper.getColorRed(), turtleWrapper.getColorGreen(), turtleWrapper.getColorBlue());
        this.turtle.setDirection(turtleWrapper.getDirection());
        this.turtle.setPenDown(turtleWrapper.isPenDown());
        this.turtle.setVisible(turtleWrapper.isVisible());
        this.turtle.setPenWidth(turtleWrapper.getPenWidth());
        this.turtle.setX(turtleWrapper.getX());
        this.turtle.setY(turtleWrapper.getY());
        this.turtle.setXor(turtleWrapper.isXor());
    }

    public String toString() {
        return this.turtle.toString();
    }

    public String to_s() {
        return this.toString();
    }

    public String inspect() {
        return this.toString();
    }
}

