/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm;

import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import java.util.ArrayList;

public class State {
    public static final SensorTypeInterface[] NO_SENSORS = new SensorTypeInterface[0];
    public static final String NO_DESCRIPTION = "";
    protected StateMachine stateMachine;
    protected boolean finalState = false;
    protected boolean barrierState = false;
    protected boolean criticalSectionState = false;
    protected ConcurrencyStatus concurrencyStatus;
    protected ArrayList<Transition> transitions = new ArrayList();
    protected String description;
    protected String name;
    protected SensorTypeInterface[] sensors;

    public State(StateMachine stateMachine, String string) {
        this(stateMachine, string, NO_DESCRIPTION, NO_SENSORS);
    }

    public State(StateMachine stateMachine, String string, String string2, SensorTypeInterface[] sensorTypeInterfaceArray) {
        this.concurrencyStatus = ConcurrencyStatus.NORMAL;
        this.stateMachine = stateMachine;
        this.name = string;
        this.description = string2;
        this.sensors = new SensorTypeInterface[sensorTypeInterfaceArray.length];
        System.arraycopy(sensorTypeInterfaceArray, 0, this.sensors, 0, sensorTypeInterfaceArray.length);
    }

    public boolean stateAdded() {
        return this.getStateMachine().contains(this);
    }

    public void setFinalState(boolean bl) {
        if (this.finalState != bl) {
            this.finalState = bl;
            this.stateMachine.getListenerSupport().fireSetFinalState(this);
        }
    }

    public void setBarrierState(boolean bl) {
        if (this.barrierState != bl) {
            this.barrierState = bl;
            this.criticalSectionState = false;
            this.stateMachine.getListenerSupport().fireSetBarrierState();
        }
    }

    public void setCriticalSectionState(boolean bl) {
        if (this.criticalSectionState != bl) {
            this.criticalSectionState = bl;
            this.barrierState = false;
            this.stateMachine.getListenerSupport().fireSetCriticalSectionState();
        }
    }

    public void setConcurrencyStatus(ConcurrencyStatus concurrencyStatus) {
        if (this.concurrencyStatus != concurrencyStatus) {
            this.concurrencyStatus = concurrencyStatus;
            this.stateMachine.getListenerSupport().fireConcurrencyStatusChanged();
        }
    }

    public ConcurrencyStatus getConcurrencyStatus() {
        return this.concurrencyStatus;
    }

    public void setName(String string) {
        if (!this.name.equals(string)) {
            String string2 = this.name;
            this.name = string;
            if (this.stateMachine.contains(this)) {
                this.stateMachine.nameSet(this, string2);
            }
            this.stateMachine.getListenerSupport().fireSetName(this, string2);
        }
    }

    public void setDescription(String string) {
        this.description = string;
        this.stateMachine.getListenerSupport().fireSetDescription(this);
    }

    protected void sensorsChanged() {
        for (int i = 0; i < this.transitions.size(); ++i) {
            Transition transition = this.transitions.get(i);
            transition.setSensors();
        }
        this.stateMachine.getListenerSupport().fireSetSensors(this);
    }

    public void removeSensor(SensorTypeInterface sensorTypeInterface) {
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[this.sensors.length];
        System.arraycopy(this.sensors, 0, sensorTypeInterfaceArray, 0, this.sensors.length);
        this.sensors = new SensorTypeInterface[this.sensors.length - 1];
        int n = 0;
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            if (sensorTypeInterfaceArray[i] == sensorTypeInterface) continue;
            this.sensors[n] = sensorTypeInterfaceArray[i];
            ++n;
        }
        this.sensorsChanged();
    }

    public void setSensors(SensorTypeInterface[] sensorTypeInterfaceArray) {
        this.sensors = new SensorTypeInterface[sensorTypeInterfaceArray.length];
        System.arraycopy(sensorTypeInterfaceArray, 0, this.sensors, 0, sensorTypeInterfaceArray.length);
        this.sensorsChanged();
    }

    public boolean isFinalState() {
        return this.finalState;
    }

    public boolean isBarrierState() {
        return this.barrierState;
    }

    public boolean isCriticalSectionState() {
        return this.criticalSectionState;
    }

    public final Transition[] getTransitions() {
        Transition[] transitionArray = new Transition[this.transitions.size()];
        this.transitions.toArray(transitionArray);
        return transitionArray;
    }

    public final Transition getTransition(int n) {
        return this.transitions.get(n);
    }

    public final int indexOf(Transition transition) {
        return this.transitions.indexOf(transition);
    }

    public final int size() {
        return this.transitions.size();
    }

    public final StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final SensorTypeInterface[] getSensors() {
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[this.sensors.length];
        System.arraycopy(this.sensors, 0, sensorTypeInterfaceArray, 0, this.sensors.length);
        return sensorTypeInterfaceArray;
    }

    public boolean usesSensor(SensorTypeInterface sensorTypeInterface) {
        boolean bl = false;
        for (int i = 0; i < this.sensors.length; ++i) {
            if (this.sensors[i] != sensorTypeInterface) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasTransitions() {
        return this.transitions.size() > 0;
    }

    public boolean contains(Transition transition) {
        return this.transitions.contains(transition);
    }

    public void addTransition(Transition transition) {
        this.addTransition(transition, this.transitions.size());
    }

    public void addTransition(Transition transition, int n) {
        this.transitions.add(n, transition);
        this.stateMachine.getListenerSupport().fireTransitionAdded(transition);
    }

    public void removeTransition(Transition transition) {
        int n = this.transitions.indexOf(transition);
        this.transitions.remove(transition);
        this.stateMachine.getListenerSupport().fireTransitionRemoved(transition, n);
    }

    public static final class ConcurrencyStatus {
        public static final ConcurrencyStatus NORMAL = new ConcurrencyStatus();
        public static final ConcurrencyStatus BARRIER_WAIT = new ConcurrencyStatus();
        public static final ConcurrencyStatus CRITICALSECTION_WAIT = new ConcurrencyStatus();

        protected ConcurrencyStatus() {
        }
    }
}

