/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm;

import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.SingleActorFsmInterpreter;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import java.util.ArrayList;
import java.util.Hashtable;

public class Transition {
    public static final int SENSOR_FALSE = 2;
    public static final int SENSOR_TRUE = 1;
    public static final int SENSOR_NOTUSED = 0;
    private State from;
    private State to;
    private int[] sensorInput;
    private ArrayList<CommandTypeInterface> commands;
    private StateMachine stateMachine;
    private Hashtable<SensorTypeInterface, Integer> sensorIndices;

    public Transition(State state, State state2) {
        this.from = state;
        this.to = state2;
        this.stateMachine = state.getStateMachine();
        this.commands = new ArrayList();
        SensorTypeInterface[] sensorTypeInterfaceArray = state.getSensors();
        this.sensorInput = this.createSensorInputArray(sensorTypeInterfaceArray.length);
        this.sensorIndices = new Hashtable(sensorTypeInterfaceArray.length);
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            this.sensorIndices.put(sensorTypeInterfaceArray[i], new Integer(i));
        }
    }

    private int[] createSensorInputArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
        return nArray;
    }

    public Transition(State state, State state2, Transition transition) {
        this(state, state2);
        int n;
        int n2 = transition.commands.size();
        for (n = 0; n < n2; ++n) {
            this.commands.add(transition.commands.get(n));
        }
        for (n = 0; n < this.sensorInput.length; ++n) {
            this.sensorInput[n] = transition.sensorInput[n];
        }
    }

    void setSensors() {
        SensorTypeInterface[] sensorTypeInterfaceArray = this.from.getSensors();
        int[] nArray = this.createSensorInputArray(sensorTypeInterfaceArray.length);
        Hashtable<SensorTypeInterface, Integer> hashtable = new Hashtable<SensorTypeInterface, Integer>(sensorTypeInterfaceArray.length);
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            hashtable.put(sensorTypeInterfaceArray[i], new Integer(i));
            Integer n = this.sensorIndices.get(sensorTypeInterfaceArray[i]);
            if (n == null) continue;
            nArray[i] = this.sensorInput[n];
        }
        this.sensorInput = nArray;
        this.sensorIndices = hashtable;
    }

    public void setTo(State state) {
        State state2 = this.to;
        this.to = state;
        this.stateMachine.getListenerSupport().fireTransitionToChanged(this, state2);
    }

    public static boolean isLegelSensorValue(int n) {
        return n >= 0 && n <= 2;
    }

    public void setSensorInput(SensorTypeInterface sensorTypeInterface, int n) {
        Integer n2 = this.sensorIndices.get(sensorTypeInterface);
        this.sensorInput[n2.intValue()] = n;
        this.stateMachine.getListenerSupport().fireTransitionInputChanged(this, sensorTypeInterface, n);
    }

    public void setCommands(CommandTypeInterface[] commandTypeInterfaceArray) {
        int n;
        for (n = 0; n < commandTypeInterfaceArray.length; ++n) {
            this.commands.add(commandTypeInterfaceArray[n]);
        }
        this.commands.clear();
        for (n = 0; n < commandTypeInterfaceArray.length; ++n) {
            this.commands.add(commandTypeInterfaceArray[n]);
        }
        this.stateMachine.getListenerSupport().fireTransitionCommandsSet(this);
    }

    public final State getTo() {
        return this.to;
    }

    public final State getFrom() {
        return this.from;
    }

    public final int getSensorInput(SensorTypeInterface sensorTypeInterface) {
        Integer n = this.sensorIndices.get(sensorTypeInterface);
        return this.sensorInput[n];
    }

    public final CommandTypeInterface getCommand(int n) {
        return this.commands.get(n);
    }

    public final CommandTypeInterface[] getCommands() {
        return this.commands.toArray(new CommandTypeInterface[this.commands.size()]);
    }

    public final boolean inputMatch(boolean[] blArray, SingleActorFsmInterpreter.Mode mode) {
        for (int i = 0; i < blArray.length; ++i) {
            int n;
            if (this.sensorInput[i] == 0) continue;
            int n2 = n = blArray[i] ? 1 : 2;
            if (mode == SingleActorFsmInterpreter.Mode.AND && n != this.sensorInput[i]) {
                return false;
            }
            if (mode != SingleActorFsmInterpreter.Mode.OR || n != this.sensorInput[i]) continue;
            return true;
        }
        return mode == SingleActorFsmInterpreter.Mode.AND;
    }

    public void addCommand(CommandTypeInterface commandTypeInterface) {
        this.addCommand(commandTypeInterface, this.commands.size());
    }

    public void addCommand(CommandTypeInterface commandTypeInterface, int n) {
        this.commands.add(n, commandTypeInterface);
        this.stateMachine.getListenerSupport().fireTransitionCommandAdded(this, n);
    }

    public void removeCommand(int n) {
        CommandTypeInterface commandTypeInterface = this.commands.get(n);
        this.commands.remove(n);
        this.stateMachine.getListenerSupport().fireTransitionCommandRemoved(this, commandTypeInterface, n);
    }

    public final int size() {
        return this.commands.size();
    }
}

