/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.kapps.actorfsm.SingleActorFsmInterpreter;
import ch.karatojava.kapps.karaide.KaraActor;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.world.WorldListener;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.FrameChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FsmStatisticsWindow
extends JFrame {
    private static final long serialVersionUID = 542815287937965615L;
    protected Hashtable<String, int[]> actorNumbers = new Hashtable();
    protected Hashtable<String, JLabel[]> actorColumns = new Hashtable();
    protected StatisticsInterpreterListener statisticsInterpreterListener = new StatisticsInterpreterListener();
    protected FrameChangeListener frameChangeListener;

    public FsmStatisticsWindow() {
        this.createGui();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        this.setIconImage(Configuration.getInstance().getImage("karamodel/$karamodel/frameicon"));
        this.setTitle(Configuration.getInstance().getString("language/$language/actorfsm/editor/statistics/title"));
        GuiFactory.getInstance().addUiSwitchListener(this);
        this.frameChangeListener = new FrameChangeListener(this);
        Configuration.getInstance().addPropertyChangeListener(this.frameChangeListener, true);
    }

    public InterpreterListener getInterpreterListener() {
        return this.statisticsInterpreterListener;
    }

    public WorldListener getWorldListener() {
        return null;
    }

    protected void createGui() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        KaraActor[] karaActorArray = KaraActorKonfig.getInstance().getKaraActors();
        this.setSize(190 + karaActorArray.length * 40, 170);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.lightGray);
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        jLabel = this.createLabel("language/$language/actorfsm/editor/statistics/transitions");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 2;
        jLabel = this.createLabel("language/$language/actorfsm/editor/statistics/nonemptytrans");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 3;
        jLabel = this.createLabel("language/$language/actorfsm/editor/statistics/commands");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        for (int i = 0; i < karaActorArray.length; ++i) {
            JLabel[] jLabelArray = new JLabel[3];
            int[] nArray = new int[3];
            gridBagConstraints.gridx = i + 1;
            gridBagConstraints.gridy = 0;
            jLabel = this.createLabel(new ImageIcon(karaActorArray[i].getIcon().getImage()));
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            for (int j = 0; j < 3; ++j) {
                gridBagConstraints.gridy = j + 1;
                jLabelArray[j] = this.createLabel();
                gridBagLayout.setConstraints(jLabelArray[j], gridBagConstraints);
                jPanel.add(jLabelArray[j]);
                nArray[j] = 0;
            }
            this.actorNumbers.put(karaActorArray[i].getName(), nArray);
            this.actorColumns.put(karaActorArray[i].getName(), jLabelArray);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        this.getContentPane().add(jPanel2);
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = GuiFactory.getInstance().createLabel(string);
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        return jLabel;
    }

    protected JLabel createLabel(ImageIcon imageIcon) {
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setOpaque(true);
        return jLabel;
    }

    protected JLabel createLabel() {
        JLabel jLabel = new JLabel("0");
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    protected void resetCounts() {
        KaraActor[] karaActorArray = KaraActorKonfig.getInstance().getKaraActors();
        for (int i = 0; i < karaActorArray.length; ++i) {
            int[] nArray = this.actorNumbers.get(karaActorArray[i].getName());
            JLabel[] jLabelArray = this.actorColumns.get(karaActorArray[i].getName());
            for (int j = 0; j < 3; ++j) {
                jLabelArray[j].setText("0");
                nArray[j] = 0;
            }
        }
    }

    protected class StatisticsInterpreterListener
    extends InterpreterListenerAdapter {
        protected static final int TRANSITION_INDEX = 0;
        protected static final int NON_EMPTY_TRANSITION_INDEX = 1;
        protected static final int COMMANDS_INDEX = 2;
        protected int[] numbers;
        protected JLabel[] labels;
        protected int commands;

        protected StatisticsInterpreterListener() {
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            FsmStatisticsWindow.this.resetCounts();
        }

        @Override
        public void endCompositeStep(RunnableInterface runnableInterface) {
            try {
                this.numbers[0] = this.numbers[0] + 1;
                if (this.commands > 0) {
                    this.numbers[1] = this.numbers[1] + 1;
                }
                this.numbers[2] = this.numbers[2] + this.commands;
                for (int i = 0; i < this.numbers.length; ++i) {
                    this.labels[i].setText(this.numbers[i] + "");
                }
                FsmStatisticsWindow.this.validate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void beginCompositeStep(RunnableInterface runnableInterface) {
            SingleActorFsmInterpreter singleActorFsmInterpreter = null;
            try {
                singleActorFsmInterpreter = (SingleActorFsmInterpreter)((StepableInterpreter)runnableInterface).getStepper();
                this.numbers = FsmStatisticsWindow.this.actorNumbers.get(singleActorFsmInterpreter.getActor().getName());
                this.labels = FsmStatisticsWindow.this.actorColumns.get(singleActorFsmInterpreter.getActor().getName());
                this.commands = singleActorFsmInterpreter.getCurrentTransition().size();
            }
            catch (Exception exception) {
                System.out.println(singleActorFsmInterpreter.getActor().getName() + this.commands);
            }
        }

        @Override
        public void stepped(RunnableInterface runnableInterface) {
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
        }
    }
}

