/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.ethz.fsmgui.controller.popups.DefaultPopup;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.ActorGuiFsmController;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class ActorDefaultPopup
extends DefaultPopup {
    private static final String ACTION_COPY = "copyStateMachine";
    private static final String ACTION_PASTE = "pasteStateMachine";
    private static final String ACTION_PASTE_STATE = "pasteState";
    private static final String ACTION_EXPORT_FSM = "exportStateMachine";
    private ActorGuiFsmController controller;
    private SingleActorFsmEditor fsmEditor;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem pasteStateItem;
    private JMenuItem exportItem;
    protected boolean concurrencyEnabled;

    public ActorDefaultPopup(SingleActorFsmEditor singleActorFsmEditor, ActorGuiFsmController actorGuiFsmController) {
        super(actorGuiFsmController, null);
        this.fsmEditor = singleActorFsmEditor;
        this.controller = actorGuiFsmController;
        this.copyItem = GuiFactory.getInstance().createMenuItem("icons/copysmall", "language/$language/actorfsm/editor/defaultpopup/copystatemachine");
        this.copyItem.setActionCommand(ACTION_COPY);
        this.copyItem.addActionListener(this);
        this.pasteItem = GuiFactory.getInstance().createMenuItem("icons/pastesmall", "language/$language/actorfsm/editor/defaultpopup/pastestatemachine");
        this.pasteItem.setActionCommand(ACTION_PASTE);
        this.pasteItem.addActionListener(this);
        this.addStateItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/addstate");
        this.addStateItem.setActionCommand("addState");
        this.addStateItem.addActionListener(this);
        this.pasteStateItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/pastestate");
        this.pasteStateItem.setActionCommand(ACTION_PASTE_STATE);
        this.pasteStateItem.addActionListener(this);
        this.clearItem = GuiFactory.getInstance().createMenuItem("icons/newsmall", "language/$language/actorfsm/editor/defaultpopup/clear");
        this.clearItem.setActionCommand("clear");
        this.clearItem.addActionListener(this);
        this.layoutMenu = GuiFactory.getInstance().createMenu(null, "language/$language/actorfsm/editor/defaultpopup/layout");
        this.fitItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/layoutfit");
        this.fitItem.setActionCommand("layoutFit");
        this.fitItem.addActionListener(this);
        this.organicItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/layoutorganic");
        this.organicItem.setActionCommand("layoutOrganic");
        this.organicItem.addActionListener(this);
        this.circleItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/layoutcircle");
        this.circleItem.setActionCommand("layoutCircle");
        this.circleItem.addActionListener(this);
        this.alignItem = GuiFactory.getInstance().createCheckBoxMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/layoutalign");
        this.alignItem.setActionCommand("layoutAlign");
        this.alignItem.addActionListener(this);
        this.styleMenu = GuiFactory.getInstance().createMenu(null, "language/$language/actorfsm/editor/defaultpopup/style");
        this.styleGroup = new ButtonGroup();
        this.style3D = GuiFactory.getInstance().createRadioButtonMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/style3d");
        this.style3D.setActionCommand("style3D");
        this.styleGroup.add(this.style3D);
        this.style3D.addActionListener(this);
        this.styleContrast = GuiFactory.getInstance().createRadioButtonMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/stylecontrast");
        this.styleContrast.setActionCommand("styleContrast");
        this.styleGroup.add(this.styleContrast);
        this.styleContrast.addActionListener(this);
        this.styleDiode = GuiFactory.getInstance().createRadioButtonMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/stylediode");
        this.styleDiode.setActionCommand("styleDiode");
        this.styleGroup.add(this.styleDiode);
        this.styleDiode.addActionListener(this);
        this.createExportItem();
        this.createMenu();
    }

    private void createExportItem() {
        this.exportItem = GuiFactory.getInstance().createMenuItem(null, "language/$language/actorfsm/editor/defaultpopup/exportfsm");
        this.exportItem.setActionCommand(ACTION_EXPORT_FSM);
        this.exportItem.addActionListener(this);
    }

    public void createMenu() {
        this.menu.removeAll();
        if (this.fsmEditor.getActorFsmEditor().countActors() > 1) {
            this.menu.add(this.copyItem);
            this.menu.add(this.pasteItem);
            this.menu.add(this.clearItem);
            this.menu.add(new JSeparator());
        }
        this.menu.add(this.pasteStateItem);
        this.menu.add(new JSeparator());
        this.menu.add(this.getLayoutMenu());
        this.menu.add(new JSeparator());
        if (!this.concurrencyEnabled) {
            this.menu.add(this.getStyleMenu());
            this.menu.add(new JSeparator());
        }
        if (this.exportItem != null) {
            this.menu.add(this.exportItem);
        }
        GuiFactory.getInstance().addUiSwitchListener(this.menu);
    }

    public void setConcurrencyEnabled(boolean bl) {
        this.concurrencyEnabled = bl;
        this.createMenu();
    }

    @Override
    public void clear(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this.fsmEditor.getFsmView(), Configuration.getInstance().getString("language/$language/actorfsm/editor/confirmnewfsm"), Configuration.getInstance().getString("language/$language/actorfsm/editor/confirmnewfsmtitle"), 0);
        if (n == 0) {
            this.fsmEditor.setNewStateMachine();
        }
    }

    public void copyStateMachine(ActionEvent actionEvent) {
        this.fsmEditor.copyToClipboard();
    }

    public void pasteStateMachine(ActionEvent actionEvent) {
        this.fsmEditor.pasteFromClipboard();
    }

    public void pasteState(ActionEvent actionEvent) {
        this.controller.pasteFromClipboard(this.lastClickX, this.lastClickY);
    }

    public void exportStateMachine(ActionEvent actionEvent) {
        this.fsmEditor.exportStateMachine();
    }

    @Override
    public JPopupMenu getPopup(int n, int n2) {
        this.lastClickX = n;
        this.lastClickY = n2;
        this.pasteItem.setEnabled(this.fsmEditor.canPasteFromClipboard());
        this.pasteStateItem.setEnabled(this.controller.canPasteFromClipboard());
        if (this.exportItem != null) {
            this.exportItem.setEnabled(this.fsmEditor.getStateMachine() != null && this.fsmEditor.getStateMachine().getStates().length > 1);
        }
        return this.menu;
    }
}

