/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.ethz.fsmgui.MVCFactory;
import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.karatojava.kapps.actorfsm.ActorFsmListener;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.ActorGuiFsmController;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.NoLabel3DRenderer;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.NoLabelContrastRenderer;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.NoLabelDiodeRenderer;
import ch.karatojava.util.Configuration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ActorGuiFsmFactory
implements MVCFactory {
    public static final double STATE_RADIUS = 40.0;
    protected static final String RENDERER_NAME_3D = "3D";
    protected static final String RENDERER_NAME_CONTRAST = "Contrast";
    protected static final String RENDERER_NAME_DIODE = "Diode";
    protected static final NoLabel3DRenderer RENDERER_3D = new NoLabel3DRenderer();
    protected static final NoLabelContrastRenderer RENDERER_CONTRAST = new NoLabelContrastRenderer();
    protected static final NoLabelDiodeRenderer RENDERER_DIODE = new NoLabelDiodeRenderer();
    protected FsmGuiStateMachine guiStateMachine;
    protected FSMView fsmView;
    protected FSMControllerInterface controller;
    protected UpdateState updateState;
    protected PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ActorGuiFsmFactory.this.setBackgroundColors();
        }
    };
    protected ActorFsmListener actorFsmListener = new ActorFsmListener.Adapter(){

        @Override
        public void transitionAdded(Transition transition) {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                FsmGuiState fsmGuiState = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getFrom());
                FsmGuiState fsmGuiState2 = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getTo());
                fsmGuiState.addTransition(FsmGuiState.DUMMY_INPUT, fsmGuiState2);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionRemoved(Transition transition, int n) {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                FsmGuiState fsmGuiState = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getFrom());
                FsmGuiState fsmGuiState2 = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getTo());
                fsmGuiState.removeTransition(FsmGuiState.DUMMY_INPUT, fsmGuiState2);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionToChanged(Transition transition, State state) {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                FsmGuiState fsmGuiState = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getFrom());
                FsmGuiState fsmGuiState2 = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(transition.getTo());
                FsmGuiState fsmGuiState3 = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(state);
                fsmGuiState.removeTransition(FsmGuiState.DUMMY_INPUT, fsmGuiState3);
                fsmGuiState.addTransition(FsmGuiState.DUMMY_INPUT, fsmGuiState2);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void setName(State state, String string) {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                FsmGuiState fsmGuiState = ActorGuiFsmFactory.this.guiStateMachine.getGuiState(state);
                fsmGuiState.setLabel(state.getName());
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void setBarrierState() {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                ActorGuiFsmFactory.this.fsmView.updateView(false);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void setCriticalSectionState() {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                ActorGuiFsmFactory.this.fsmView.updateView(false);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void concurrencyStatusChanged() {
            if (!ActorGuiFsmFactory.this.updateState.isViewModelUpdated()) {
                ActorGuiFsmFactory.this.updateState.setDataModelState(true);
                ActorGuiFsmFactory.this.fsmView.updateView(false);
                ActorGuiFsmFactory.this.updateState.setDataModelState(false);
            }
        }
    };

    public ActorGuiFsmFactory(SingleActorFsmEditor singleActorFsmEditor, ActorTypeInterface actorTypeInterface, FsmGuiStateMachine fsmGuiStateMachine) {
        Configuration.getInstance().addPropertyChangeListener("color", this.changeListener, false);
        this.guiStateMachine = fsmGuiStateMachine;
        this.updateState = fsmGuiStateMachine.getUpdateState();
        fsmGuiStateMachine.getStateMachine().addActorFsmListener(this.actorFsmListener);
        this.createFsmView();
        this.controller = new ActorGuiFsmController(singleActorFsmEditor, fsmGuiStateMachine, this.fsmView);
        this.setStopState();
    }

    public void setStateMachine(FsmGuiStateMachine fsmGuiStateMachine) {
        this.guiStateMachine = fsmGuiStateMachine;
        this.updateState = fsmGuiStateMachine.getUpdateState();
        fsmGuiStateMachine.getStateMachine().addActorFsmListener(this.actorFsmListener);
        ((ActorGuiFsmController)this.controller).setModel(fsmGuiStateMachine);
        this.setStopState();
    }

    protected void createFsmView() {
        this.fsmView = new FSMView(this.guiStateMachine);
        this.fsmView.minStateDist = 100;
        this.fsmView.registerRenderer(RENDERER_NAME_3D, RENDERER_3D);
        this.fsmView.registerRenderer(RENDERER_NAME_DIODE, RENDERER_DIODE);
        this.fsmView.registerRenderer(RENDERER_NAME_CONTRAST, RENDERER_CONTRAST);
        this.fsmView.chooseRenderer(RENDERER_NAME_CONTRAST);
        this.setBackgroundColors();
    }

    protected void setStopState() {
        State[] stateArray = this.guiStateMachine.getStateMachine().getStates();
        FsmGuiState fsmGuiState = null;
        for (int i = 0; i < stateArray.length; ++i) {
            if (!stateArray[i].isFinalState()) continue;
            fsmGuiState = this.guiStateMachine.getGuiState(stateArray[i]);
        }
        ((ActorGuiFsmController)this.controller).setStopState(fsmGuiState);
    }

    protected void setBackgroundColors() {
        RENDERER_DIODE.setBackground(UIManager.getColor("Panel.background"));
        RENDERER_CONTRAST.setBackground(UIManager.getColor("Panel.background"));
        RENDERER_3D.setBackground(UIManager.getColor("Panel.background"));
    }

    @Override
    public FSMModelInterface getModel() {
        return this.guiStateMachine;
    }

    @Override
    public JComponent getView() {
        return this.fsmView;
    }

    @Override
    public FSMControllerInterface getController() {
        return this.controller;
    }

    static {
        RENDERER_3D.setStateRadius(40.0);
        RENDERER_CONTRAST.setStateRadius(40.0);
        RENDERER_DIODE.setStateRadius(40.0);
    }
}

