/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.ethz.fsmgui.FSMEvent;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import java.util.HashSet;
import java.util.Set;

public class FsmGuiState
implements FSMStateInterface {
    public static final Character DUMMY_INPUT = new Character('-');
    public static final Set<Character> DUMMY_INPUT_SET = new HashSet<Character>();
    private State state;
    private UpdateState updateState;
    private FsmGuiStateMachine fsmGuiStateMachine;
    private double x;
    private double y;

    public FsmGuiState(FsmGuiStateMachine fsmGuiStateMachine, State state, UpdateState updateState) {
        this.state = state;
        this.fsmGuiStateMachine = fsmGuiStateMachine;
        this.updateState = updateState;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void setPosition(double d, double d2) {
        if (this.x != d || this.y != d2) {
            this.x = d;
            this.y = d2;
            this.fsmGuiStateMachine.getActorFsmEditor().setModified();
        }
        this.fsmGuiStateMachine.notifyFSMModelListeners(FSMEvent.createStatePosChangedEvent(this));
    }

    @Override
    public void setLabel(Object object) {
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            this.state.setName((String)object);
            this.updateState.setViewModelState(false);
        }
        this.fsmGuiStateMachine.notifyFSMModelListeners(FSMEvent.createSetStateLabelEvent(this, object));
    }

    @Override
    public void setAccepting(boolean bl) {
        this.state.setFinalState(bl);
        this.fsmGuiStateMachine.notifyFSMModelListeners(FSMEvent.createSetAcceptingEvent(this, bl));
    }

    @Override
    public Set getInputs() {
        return DUMMY_INPUT_SET;
    }

    @Override
    public Set getNextStateSet(Object object) {
        HashSet<FsmGuiState> hashSet = new HashSet<FsmGuiState>();
        Transition[] transitionArray = this.state.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            FsmGuiState fsmGuiState = this.fsmGuiStateMachine.getGuiState(transitionArray[i].getTo());
            hashSet.add(fsmGuiState);
        }
        return hashSet;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Object getLabel() {
        return this.state.getName();
    }

    @Override
    public boolean isAccepting() {
        return this.state.isFinalState();
    }

    @Override
    public boolean isStartState() {
        return this.state.getStateMachine().getStartState() == this.state;
    }

    public boolean isBarrierState() {
        return this.state.isBarrierState();
    }

    public boolean isCriticalSectionState() {
        return this.state.isCriticalSectionState();
    }

    @Override
    public void addTransition(Object object, FSMStateInterface fSMStateInterface) {
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            this.state.addTransition(new Transition(this.state, ((FsmGuiState)fSMStateInterface).state));
            this.updateState.setViewModelState(false);
        }
        this.fsmGuiStateMachine.notifyFSMModelListeners(FSMEvent.createAddTransitionEvent(this, fSMStateInterface, DUMMY_INPUT));
    }

    private boolean hasTransitionTo(State state) {
        Transition[] transitionArray = this.state.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            if (transitionArray[i].getTo() != state) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeTransition(Object object, FSMStateInterface fSMStateInterface) {
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            Transition[] transitionArray = this.state.getTransitions();
            for (int i = 0; i < transitionArray.length; ++i) {
                if (transitionArray[i].getTo() != ((FsmGuiState)fSMStateInterface).state) continue;
                this.state.removeTransition(transitionArray[i]);
            }
            this.updateState.setViewModelState(false);
        }
        if (!this.hasTransitionTo(((FsmGuiState)fSMStateInterface).state)) {
            this.fsmGuiStateMachine.notifyFSMModelListeners(FSMEvent.createDeleteTransitionEvent(this, fSMStateInterface, DUMMY_INPUT));
        }
    }

    static {
        DUMMY_INPUT_SET.add(DUMMY_INPUT);
    }
}

