/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StateDialog
extends JDialog {
    private static final long serialVersionUID = 2815806945218073056L;
    protected static final int DESCRIPTION_WIDTH = 25;
    protected static final int DESCRIPTION_HEIGHT = 2;
    protected JLabel nameLabel;
    protected JTextField stateName;
    protected JTextArea stateDescription;
    protected ActorTypeInterface actor;
    protected StateMachine stateMachine;
    protected State state;
    protected ArrayList<SensorTypeInterface> selectedSensors;
    protected SelectedSensorsView selectedSensorView;
    protected LibraryView libraryView;
    protected JScrollPane selectedScrollPane;
    protected JScrollPane libraryScrollPane;
    protected TrashButton sensorViewTrash;
    protected DndPanel mainPanel;
    protected SensorTypeInterface dragOrigin;
    protected SensorTypeInterface dragEnd;
    protected SensorTypeInterface[] sensors;
    protected int returnValue;

    public StateDialog(Frame frame, String string, ActorTypeInterface actorTypeInterface) {
        super(frame, string, true);
        this.actor = actorTypeInterface;
        this.selectedSensors = new ArrayList();
        this.stateName = new JTextField(25);
        this.stateDescription = new JTextArea(4, 25);
        this.createSensors();
        this.createGUI();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StateDialog.this.returnValue = 2;
                StateDialog.this.setVisible(false);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        GuiFactory.getInstance().addUiSwitchListener(this);
    }

    protected void createSensors() {
        this.sensors = this.actor.getSensors();
    }

    public void resetView() {
        this.resetLibraryView();
        this.resetSelectedSensorView();
    }

    public void resetLibraryView() {
        this.createSensors();
        this.libraryView.resetSensors();
        this.libraryScrollPane.setViewportView(this.libraryView);
        this.libraryScrollPane.validate();
        this.mainPanel.addThisMouseInputListener(this.libraryView);
    }

    public void resetSelectedSensorView() {
        int n = this.selectedScrollPane.getVerticalScrollBar().getValue();
        this.mainPanel.removeThisMouseInputListener(this.selectedSensorView);
        this.selectedSensorView.resetSensors();
        this.selectedScrollPane.setViewportView(this.selectedSensorView);
        this.selectedScrollPane.validate();
        this.selectedScrollPane.getVerticalScrollBar().setValue(n);
        this.sensorViewTrash.setParent(this.selectedSensorView);
        this.mainPanel.addThisMouseInputListener(this.selectedSensorView);
    }

    protected void createGUI() {
        Container container = this.getContentPane();
        final JButton jButton = GuiFactory.getInstance().createImageIconButton("icons/ok");
        JButton jButton2 = GuiFactory.getInstance().createImageIconButton("icons/cancel");
        container.setLayout(new BorderLayout());
        container.add((Component)this.createNamePanel(), "North");
        container.add((Component)this.createMainPanel(), "Center");
        container.add((Component)this.createButtonPanel(jButton, jButton2), "South");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    StateDialog.this.returnValue = 2;
                    StateDialog.this.setVisible(false);
                } else if (keyEvent.getKeyChar() == '\n') {
                    jButton.doClick();
                }
            }
        };
        this.addKeyListener(keyAdapter);
        this.stateName.addKeyListener(keyAdapter);
        this.stateDescription.addKeyListener(keyAdapter);
    }

    protected DndPanel createMainPanel() {
        this.mainPanel = new DndPanel();
        this.mainPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/sensordialog/usedsensortitle"), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        this.selectedSensorView = new SelectedSensorsView(this);
        this.selectedScrollPane = new JScrollPane(this.selectedSensorView);
        this.selectedScrollPane.setPreferredSize(new Dimension(150, 150));
        jPanel.add(this.selectedScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.sensorViewTrash = new TrashButton(this.selectedSensorView);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.sensorViewTrash);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/sensordialog/librarytitle"), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        this.libraryView = new LibraryView(this);
        this.libraryScrollPane = new JScrollPane(this.libraryView);
        jPanel3.add(this.libraryScrollPane);
        this.mainPanel.add(jPanel);
        this.mainPanel.add(jPanel3);
        this.mainPanel.addThisMouseInputListenerToChildren();
        return this.mainPanel;
    }

    protected JPanel createNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.nameLabel = GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/sensordialog/namelabel");
        jPanel.add(this.nameLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        this.stateName.setBackground(Color.white);
        jPanel.add(this.stateName);
        return jPanel;
    }

    protected JPanel createButtonPanel(JButton jButton, JButton jButton2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 15, 20, 15));
        jPanel.add(Box.createHorizontalGlue());
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(15));
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jButton.addActionListener(new ExceptionActionListener(){

            @Override
            public void action(ActionEvent actionEvent) throws Exception {
                StateDialog.this.addState();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateDialog.this.returnValue = 2;
                StateDialog.this.setVisible(false);
            }
        });
        return jPanel;
    }

    protected void addState() throws Exception {
        if (this.stateName.getText().equals("")) {
            this.stateName.requestFocus();
            throw new Exception(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/nonameerrormsg"));
        }
        State state = this.stateMachine.getState(this.stateName.getText());
        if (state != null && state != this.state) {
            this.stateName.requestFocus();
            throw new Exception(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/dupnameerrormsg"));
        }
        this.createSelectedSensors();
        this.returnValue = 0;
        this.setVisible(false);
    }

    protected void createSelectedSensors() {
    }

    public void show(StateMachine stateMachine) {
        this.setTitle(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/titlenew"));
        this.stateMachine = stateMachine;
        this.state = null;
        this.returnValue = 2;
        this.stateName.setText("");
        this.stateDescription.setText("");
        this.selectedSensors.clear();
        this.selectedSensorView.reset();
        this.stateName.requestFocus();
        this.setVisible(true);
    }

    public void show(State state) {
        this.setTitle(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/titleedit"));
        this.stateMachine = state.getStateMachine();
        this.state = state;
        this.returnValue = 2;
        this.stateName.setText(state.getName());
        this.stateDescription.setText(state.getDescription());
        this.selectedSensors.clear();
        for (int i = 0; i < state.getSensors().length; ++i) {
            this.selectedSensors.add(state.getSensors()[i]);
        }
        this.selectedSensorView.reset();
        this.setVisible(true);
    }

    public int getValue() {
        return this.returnValue;
    }

    public SensorTypeInterface[] getSelectedSensors() {
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[this.selectedSensors.size()];
        this.selectedSensors.toArray(sensorTypeInterfaceArray);
        return sensorTypeInterfaceArray;
    }

    public String getStateName() {
        return this.stateName.getText();
    }

    public String getDescription() {
        return this.stateDescription.getText();
    }

    protected static interface SensorContainerInterface {
        public void setDragginState(boolean var1);

        public boolean getDraggingState();

        public void sensorTrashed(SensorTypeInterface var1);

        public boolean acceptsDrop(MouseEvent var1, Object var2);

        public void dropTransferObject(MouseEvent var1, Object var2);
    }

    protected class TrashButton
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = -3208945690869238535L;
        private SensorContainerInterface parent;

        public TrashButton(SensorContainerInterface sensorContainerInterface) {
            super(GuiFactory.getInstance().createImageIcon("icons/trashcan"));
            this.parent = sensorContainerInterface;
        }

        public void setParent(SensorContainerInterface sensorContainerInterface) {
            this.parent = sensorContainerInterface;
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            return null;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return this.parent.getDraggingState();
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            SensorTypeInterface sensorTypeInterface = (SensorTypeInterface)object;
            if (this.parent.getDraggingState()) {
                this.parent.sensorTrashed(sensorTypeInterface);
            }
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            return null;
        }
    }

    protected class DragableLabel
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = -7910349728318395724L;
        SensorTypeInterface sensor;
        BufferedImage dragImage;
        SensorContainerInterface sensorContainer;

        public DragableLabel(SensorTypeInterface sensorTypeInterface, SensorContainerInterface sensorContainerInterface) {
            super(sensorTypeInterface.getDescription(), sensorTypeInterface.getIcon(), 0);
            if (sensorTypeInterface.getAttribute("descPath") != null) {
                String string = (String)sensorTypeInterface.getAttribute("descPath");
                this.setText(Configuration.getInstance().getString(string));
            }
            this.sensor = sensorTypeInterface;
            this.sensorContainer = sensorContainerInterface;
            StateDialog.this.mainPanel.addThisMouseInputListener(this);
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            if (this.dragImage == null) {
                this.dragImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
                this.paint(this.dragImage.getGraphics());
            }
            this.sensorContainer.setDragginState(true);
            StateDialog.this.dragOrigin = this.sensor;
            return this.sensor;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return this.sensorContainer.acceptsDrop(mouseEvent, object);
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            return this.dragImage;
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
            this.sensorContainer.setDragginState(false);
            StateDialog.this.dragOrigin = null;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            StateDialog.this.dragEnd = this.sensor;
            this.sensorContainer.dropTransferObject(mouseEvent, object);
            StateDialog.this.dragEnd = null;
        }

        public SensorTypeInterface getSensor() {
            return this.sensor;
        }
    }

    protected class SelectedSensorsView
    extends JPanel
    implements LightweightDragDrop,
    SensorContainerInterface {
        private static final long serialVersionUID = 7615786592911030669L;
        private Dimension d = new Dimension(5, 36);
        private StateDialog parent;
        private boolean dragging = false;

        public SelectedSensorsView(StateDialog stateDialog2) {
            this.parent = stateDialog2;
            this.createGUI();
        }

        private void createGUI() {
            this.setLayout(new BoxLayout(this, 1));
            for (int i = 0; i < StateDialog.this.selectedSensors.size(); ++i) {
                JPanel jPanel = new JPanel();
                SensorTypeInterface sensorTypeInterface = StateDialog.this.selectedSensors.get(i);
                this.d = new Dimension(5, sensorTypeInterface.getIcon().getIconHeight() + 8);
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.add(Box.createRigidArea(this.d));
                jPanel.add(new DragableLabel(sensorTypeInterface, this));
                jPanel.add(Box.createHorizontalGlue());
                this.add(jPanel);
            }
        }

        public void resetSensors() {
            this.removeAll();
            this.createGUI();
        }

        public void reset() {
            this.parent.resetSelectedSensorView();
        }

        @Override
        public void setDragginState(boolean bl) {
            this.dragging = bl;
        }

        @Override
        public boolean getDraggingState() {
            return this.dragging;
        }

        @Override
        public void sensorTrashed(SensorTypeInterface sensorTypeInterface) {
            StateDialog.this.selectedSensors.remove(sensorTypeInterface);
            this.reset();
        }

        public void addSensor(SensorTypeInterface sensorTypeInterface) {
            if (!StateDialog.this.selectedSensors.contains(sensorTypeInterface)) {
                StateDialog.this.selectedSensors.add(sensorTypeInterface);
                this.reset();
            }
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            return null;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return true;
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            return null;
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            if (StateDialog.this.dragOrigin != null && StateDialog.this.dragEnd != null && StateDialog.this.dragOrigin != StateDialog.this.dragEnd) {
                if (StateDialog.this.selectedSensors.contains(StateDialog.this.dragOrigin)) {
                    StateDialog.this.selectedSensors.remove(StateDialog.this.dragOrigin);
                }
                StateDialog.this.selectedSensors.add(StateDialog.this.selectedSensors.indexOf(StateDialog.this.dragEnd), StateDialog.this.dragOrigin);
                this.reset();
            }
            if (!StateDialog.this.selectedSensors.contains(object)) {
                StateDialog.this.selectedSensors.add((SensorTypeInterface)object);
                this.reset();
            }
        }
    }

    protected class LibraryView
    extends JPanel
    implements SensorContainerInterface {
        private static final long serialVersionUID = -323874717405659162L;
        protected Dimension d = new Dimension(5, 36);
        protected StateDialog parent;
        protected boolean dragging = false;
        private MouseListener doubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StateDialog.this.selectedSensorView.addSensor(((DragableLabel)mouseEvent.getSource()).getSensor());
                }
            }
        };

        public LibraryView(StateDialog stateDialog2) {
            this.parent = stateDialog2;
            this.createGUI();
        }

        private void createGUI() {
            this.setLayout(new BoxLayout(this, 1));
            this.d = new Dimension(5, StateDialog.this.sensors[0].getIcon().getIconHeight() + 8);
            for (int i = 0; i < StateDialog.this.sensors.length; ++i) {
                DragableLabel dragableLabel = new DragableLabel(StateDialog.this.sensors[i], this);
                dragableLabel.addMouseListener(this.doubleClickListener);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.add(Box.createRigidArea(this.d));
                jPanel.add(dragableLabel);
                jPanel.add(Box.createHorizontalGlue());
                this.add(jPanel);
            }
        }

        public void resetSensors() {
            this.removeAll();
            this.createGUI();
        }

        @Override
        public void setDragginState(boolean bl) {
            this.dragging = bl;
        }

        @Override
        public boolean getDraggingState() {
            return this.dragging;
        }

        @Override
        public void sensorTrashed(SensorTypeInterface sensorTypeInterface) {
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return false;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        }
    }
}

