/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.io;

import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorFactoryInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import ch.karatojava.kapps.actorfsm.editor.io.StateMachineOutputter;
import ch.karatojava.kapps.actorfsm.editor.io.XmlCommand;
import ch.karatojava.kapps.actorfsm.editor.io.XmlCommands;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensor;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorDefinition;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorValue;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorValues;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensors;
import ch.karatojava.kapps.actorfsm.editor.io.XmlState;
import ch.karatojava.kapps.actorfsm.editor.io.XmlStateMachine;
import ch.karatojava.kapps.actorfsm.editor.io.XmlStateMachines;
import ch.karatojava.kapps.actorfsm.editor.io.XmlTransition;
import ch.karatojava.kapps.karaide.CommandType;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.util.Configuration;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class StateMachineBuilder {
    protected static StateMachineBuilder builder;

    protected StateMachineBuilder() {
    }

    public static Hashtable buildStateMachines(ActorFsmEditor actorFsmEditor, InputStream inputStream, ActorInterface[] actorInterfaceArray) throws Exception {
        try {
            JAXBContext jAXBContext;
            Unmarshaller unmarshaller;
            XmlStateMachines xmlStateMachines;
            String string;
            if (builder == null) {
                builder = new StateMachineBuilder();
            }
            if (!(string = (xmlStateMachines = (XmlStateMachines)(unmarshaller = (jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.actorfsm.editor.io")).createUnmarshaller()).unmarshal(inputStream)).getVersion()).equalsIgnoreCase(StateMachineOutputter.version)) {
                String[] stringArray = new String[]{string, StateMachineOutputter.version};
                throw new KaraException("language/$language/iomessages/wrongversion", stringArray);
            }
            builder.createSensors(xmlStateMachines.getXmlSensorDefinition(), actorInterfaceArray[0].getActorType());
            List<XmlStateMachine> list = xmlStateMachines.getXmlStateMachine();
            if (actorInterfaceArray.length != list.size()) {
                throw new Exception("Program for actor missing in file, or too many programs.");
            }
            Hashtable<ActorInterface, FsmGuiStateMachine> hashtable = new Hashtable<ActorInterface, FsmGuiStateMachine>();
            for (int i = 0; i < list.size(); ++i) {
                XmlStateMachine xmlStateMachine = list.get(i);
                ActorInterface actorInterface = builder.getActor(actorInterfaceArray, xmlStateMachine.getActor());
                if (actorInterface == null) {
                    throw new KaraException("language/$language/iomessages/invalidactorname");
                }
                if (hashtable.get(actorInterface) != null) {
                    throw new Exception("Two programs for one actor.");
                }
                FsmGuiStateMachine fsmGuiStateMachine = builder.buildStateMachine(actorFsmEditor, actorInterface.getActorType(), xmlStateMachine);
                hashtable.put(actorInterface, fsmGuiStateMachine);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = MessageFormat.format(Configuration.getInstance().getString("language/$language/iomessages/error"), string);
            throw new Exception(string2);
        }
    }

    protected ActorInterface getActor(ActorInterface[] actorInterfaceArray, String string) {
        for (int i = 0; i < actorInterfaceArray.length; ++i) {
            if (!actorInterfaceArray[i].getName().equals(string)) continue;
            return actorInterfaceArray[i];
        }
        return null;
    }

    protected Hashtable<String, SensorTypeInterface> getSensorTypes(ActorTypeInterface actorTypeInterface) {
        Hashtable<String, SensorTypeInterface> hashtable = new Hashtable<String, SensorTypeInterface>();
        SensorTypeInterface[] sensorTypeInterfaceArray = actorTypeInterface.getSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            hashtable.put(sensorTypeInterfaceArray[i].getIdentifier(), sensorTypeInterfaceArray[i]);
        }
        return hashtable;
    }

    protected Hashtable<String, CommandTypeInterface> getCommandTypes(ActorTypeInterface actorTypeInterface) {
        Hashtable<String, CommandTypeInterface> hashtable = new Hashtable<String, CommandTypeInterface>();
        CommandTypeInterface[] commandTypeInterfaceArray = actorTypeInterface.getCommands();
        for (int i = 0; i < commandTypeInterfaceArray.length; ++i) {
            hashtable.put(commandTypeInterfaceArray[i].getName(), commandTypeInterfaceArray[i]);
        }
        return hashtable;
    }

    protected void createSensors(List list, ActorTypeInterface actorTypeInterface) throws Exception {
        actorTypeInterface.removeAllSensors();
        SensorFactoryInterface sensorFactoryInterface = KaraActorKonfig.getSensorFactory();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            String string3;
            XmlSensorDefinition xmlSensorDefinition = (XmlSensorDefinition)list.get(i);
            if (actorTypeInterface.addSystemSensor(xmlSensorDefinition.getIdentifier())) continue;
            String string4 = xmlSensorDefinition.getIdentifier();
            if (!sensorFactoryInterface.areParametersValid(string4, string3 = xmlSensorDefinition.getName(), string2 = xmlSensorDefinition.getDescription(), string = xmlSensorDefinition.getParameterString())) {
                throw new Exception("Invalid sensor definition.");
            }
            actorTypeInterface.addSensorTypeInterface(sensorFactoryInterface.createSensor(string4, string3, string2, string));
        }
    }

    protected FsmGuiStateMachine buildStateMachine(ActorFsmEditor actorFsmEditor, ActorTypeInterface actorTypeInterface, XmlStateMachine xmlStateMachine) throws Exception {
        Object object;
        Hashtable<String, SensorTypeInterface> hashtable = this.getSensorTypes(actorTypeInterface);
        Hashtable<String, CommandTypeInterface> hashtable2 = this.getCommandTypes(actorTypeInterface);
        StateMachine stateMachine = new StateMachine();
        UpdateState updateState = new UpdateState();
        FsmGuiStateMachine fsmGuiStateMachine = new FsmGuiStateMachine(actorFsmEditor, stateMachine, updateState);
        List<XmlState> list = xmlStateMachine.getXmlState();
        for (int i = 0; i < list.size(); ++i) {
            XmlState xmlState = list.get(i);
            State state = this.createState(hashtable, stateMachine, xmlState);
            object = new FsmGuiState(fsmGuiStateMachine, state, updateState);
            ((FsmGuiState)object).setPosition(xmlState.getX(), xmlState.getY());
            fsmGuiStateMachine.addState((FSMStateInterface)object);
        }
        State[] stateArray = stateMachine.getStates();
        int n = 0;
        for (int i = 0; i < stateArray.length; ++i) {
            if (!stateArray[i].isFinalState()) continue;
            if (stateArray[i].size() > 0) {
                throw new Exception("Final state may not have transitions.");
            }
            ++n;
        }
        if (n != 1) {
            throw new Exception("No stop state or multiple stop states.");
        }
        List<XmlTransition> list2 = xmlStateMachine.getXmlTransition();
        for (int i = 0; i < list2.size(); ++i) {
            XmlTransition xmlTransition = list2.get(i);
            object = stateMachine.getState(xmlTransition.getFrom());
            if (object == null) {
                throw new Exception("Invalid from state name " + xmlTransition.getFrom());
            }
            State state = stateMachine.getState(xmlTransition.getTo());
            if (state == null) {
                throw new Exception("Invalid to state name " + xmlTransition.getTo());
            }
            Transition transition = new Transition((State)object, state);
            this.addSensorValues(hashtable, transition, xmlTransition.getXmlSensorValues());
            this.addCommands(hashtable2, transition, xmlTransition.getXmlCommands());
            ((State)object).addTransition(transition);
        }
        String string = xmlStateMachine.getStartState();
        if (string != null) {
            State state = stateMachine.getState(string);
            if (state == null) {
                throw new Exception("Invalid start state name " + string);
            }
            fsmGuiStateMachine.setStartState(fsmGuiStateMachine.getGuiState(state));
        }
        return fsmGuiStateMachine;
    }

    protected void addSensorValues(Hashtable hashtable, Transition transition, XmlSensorValues xmlSensorValues) throws Exception {
        for (int i = 0; i < xmlSensorValues.getXmlSensorValue().size(); ++i) {
            XmlSensorValue xmlSensorValue = xmlSensorValues.getXmlSensorValue().get(i);
            SensorTypeInterface sensorTypeInterface = (SensorTypeInterface)hashtable.get(xmlSensorValue.getName());
            if (sensorTypeInterface == null) {
                throw new Exception("Invalid sensor name " + xmlSensorValue.getName());
            }
            int n = xmlSensorValue.getValue();
            if (!Transition.isLegelSensorValue(n)) {
                throw new Exception("Invalid sensor value " + n);
            }
            transition.setSensorInput(sensorTypeInterface, n);
        }
    }

    protected void addCommands(Hashtable hashtable, Transition transition, XmlCommands xmlCommands) throws Exception {
        CommandTypeInterface[] commandTypeInterfaceArray = new CommandType[xmlCommands.getXmlCommand().size()];
        for (int i = 0; i < xmlCommands.getXmlCommand().size(); ++i) {
            XmlCommand xmlCommand = xmlCommands.getXmlCommand().get(i);
            String string = xmlCommand.getName();
            if (hashtable.get(string) == null) {
                throw new Exception("Invalid command name " + string);
            }
            commandTypeInterfaceArray[i] = new CommandType(string);
        }
        transition.setCommands(commandTypeInterfaceArray);
    }

    protected State createState(Hashtable hashtable, StateMachine stateMachine, XmlState xmlState) throws Exception {
        String string = xmlState.getName();
        if (stateMachine.getState(string) != null) {
            throw new Exception("Duplicate state name.");
        }
        State state = new State(stateMachine, string);
        state.setFinalState(xmlState.isFinalstate());
        state.setSensors(this.createSensors(hashtable, xmlState.getXmlSensors()));
        if (xmlState.isFinalstate() != null && xmlState.isFinalstate().booleanValue() && xmlState.isCriticalsectionstate() != null && xmlState.isCriticalsectionstate().booleanValue()) {
            throw new Exception("Final state can't be a critical section.");
        }
        if (xmlState.isFinalstate() != null && xmlState.isFinalstate().booleanValue() && xmlState.isBarrierstate() != null && xmlState.isBarrierstate().booleanValue()) {
            throw new Exception("Final state can't be a barrier.");
        }
        if (xmlState.isCriticalsectionstate() != null && xmlState.isCriticalsectionstate().booleanValue() && xmlState.isBarrierstate() != null && xmlState.isBarrierstate().booleanValue()) {
            throw new Exception("State is critical section and barrier at the same time.");
        }
        if (xmlState.isBarrierstate() != null && xmlState.isBarrierstate().booleanValue()) {
            state.setBarrierState(xmlState.isBarrierstate());
        }
        if (xmlState.isCriticalsectionstate() != null && xmlState.isCriticalsectionstate().booleanValue()) {
            state.setCriticalSectionState(xmlState.isCriticalsectionstate());
        }
        return state;
    }

    protected SensorTypeInterface[] createSensors(Hashtable hashtable, XmlSensors xmlSensors) throws Exception {
        List<XmlSensor> list = xmlSensors.getXmlSensor();
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[list.size()];
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            XmlSensor xmlSensor = list.get(i);
            sensorTypeInterfaceArray[i] = (SensorTypeInterface)hashtable.get(xmlSensor.getName());
            if (sensorTypeInterfaceArray[i] != null) continue;
            throw new Exception("Invalid sensor name " + xmlSensor.getName());
        }
        return sensorTypeInterfaceArray;
    }
}

