/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.io;

import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import ch.karatojava.kapps.actorfsm.editor.io.XmlCommand;
import ch.karatojava.kapps.actorfsm.editor.io.XmlCommands;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensor;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorDefinition;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorValue;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensorValues;
import ch.karatojava.kapps.actorfsm.editor.io.XmlSensors;
import ch.karatojava.kapps.actorfsm.editor.io.XmlState;
import ch.karatojava.kapps.actorfsm.editor.io.XmlStateMachine;
import ch.karatojava.kapps.actorfsm.editor.io.XmlStateMachines;
import ch.karatojava.kapps.actorfsm.editor.io.XmlTransition;
import ch.karatojava.util.Configuration;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.bind.JAXBContext;

public class StateMachineOutputter {
    public static String version = "KaraX 1.0 " + Configuration.getInstance().getString("karamodel/$karamodel/savefiletype");

    public static void outputStateMachine(Hashtable hashtable, OutputStream outputStream, ActorTypeInterface actorTypeInterface) throws Exception {
        FsmGuiStateMachine fsmGuiStateMachine;
        ActorInterface actorInterface;
        XmlStateMachines xmlStateMachines = new XmlStateMachines();
        xmlStateMachines.setVersion(version);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            actorInterface = (ActorInterface)enumeration.nextElement();
            fsmGuiStateMachine = (FsmGuiStateMachine)hashtable.get(actorInterface);
            StateMachineOutputter.outputStateMachine(xmlStateMachines, actorInterface, fsmGuiStateMachine);
        }
        StateMachineOutputter.outputSensorDescritions(xmlStateMachines, actorTypeInterface);
        actorInterface = JAXBContext.newInstance((String)"ch.karatojava.kapps.actorfsm.editor.io");
        fsmGuiStateMachine = actorInterface.createMarshaller();
        fsmGuiStateMachine.setProperty("jaxb.formatted.output", Boolean.TRUE);
        fsmGuiStateMachine.marshal(xmlStateMachines, outputStream);
    }

    private static void outputStateMachine(XmlStateMachines xmlStateMachines, ActorInterface actorInterface, FsmGuiStateMachine fsmGuiStateMachine) {
        XmlStateMachine xmlStateMachine = new XmlStateMachine();
        xmlStateMachine.setActor(actorInterface.getName());
        if (fsmGuiStateMachine.getStartState() != null) {
            xmlStateMachine.setStartState((String)fsmGuiStateMachine.getStartState().getLabel());
        }
        for (FsmGuiState fsmGuiState : fsmGuiStateMachine.getAllStates()) {
            StateMachineOutputter.outputState(xmlStateMachine, fsmGuiState);
        }
        xmlStateMachines.getXmlStateMachine().add(xmlStateMachine);
    }

    private static void outputState(XmlStateMachine xmlStateMachine, FsmGuiState fsmGuiState) {
        XmlState xmlState = new XmlState();
        xmlState.setX(fsmGuiState.getX());
        xmlState.setY(fsmGuiState.getY());
        xmlState.setName((String)fsmGuiState.getLabel());
        xmlState.setFinalstate(fsmGuiState.isAccepting());
        if (fsmGuiState.isBarrierState()) {
            xmlState.setBarrierstate(fsmGuiState.isBarrierState());
        }
        if (fsmGuiState.isCriticalSectionState()) {
            xmlState.setCriticalsectionstate(fsmGuiState.isCriticalSectionState());
        }
        StateMachineOutputter.outputSensors(xmlState, fsmGuiState.getState().getSensors());
        Transition[] transitionArray = fsmGuiState.getState().getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            StateMachineOutputter.outputTransition(xmlStateMachine, transitionArray[i]);
        }
        xmlStateMachine.getXmlState().add(xmlState);
    }

    private static void outputSensors(XmlState xmlState, SensorTypeInterface[] sensorTypeInterfaceArray) {
        XmlSensors xmlSensors = new XmlSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            XmlSensor xmlSensor = new XmlSensor();
            xmlSensor.setName(sensorTypeInterfaceArray[i].getIdentifier());
            xmlSensors.getXmlSensor().add(xmlSensor);
        }
        xmlState.setXmlSensors(xmlSensors);
    }

    private static void outputTransition(XmlStateMachine xmlStateMachine, Transition transition) {
        XmlTransition xmlTransition = new XmlTransition();
        xmlTransition.setFrom(transition.getFrom().getName());
        xmlTransition.setTo(transition.getTo().getName());
        StateMachineOutputter.outputCommands(xmlTransition, transition.getCommands());
        StateMachineOutputter.outputSensorValues(xmlTransition, transition);
        xmlStateMachine.getXmlTransition().add(xmlTransition);
    }

    private static void outputCommands(XmlTransition xmlTransition, CommandTypeInterface[] commandTypeInterfaceArray) {
        XmlCommands xmlCommands = new XmlCommands();
        for (int i = 0; i < commandTypeInterfaceArray.length; ++i) {
            XmlCommand xmlCommand = new XmlCommand();
            xmlCommand.setName(commandTypeInterfaceArray[i].getName());
            xmlCommands.getXmlCommand().add(xmlCommand);
        }
        xmlTransition.setXmlCommands(xmlCommands);
    }

    private static void outputSensorValues(XmlTransition xmlTransition, Transition transition) {
        XmlSensorValues xmlSensorValues = new XmlSensorValues();
        SensorTypeInterface[] sensorTypeInterfaceArray = transition.getFrom().getSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            XmlSensorValue xmlSensorValue = new XmlSensorValue();
            xmlSensorValue.setName(sensorTypeInterfaceArray[i].getIdentifier());
            xmlSensorValue.setValue(transition.getSensorInput(sensorTypeInterfaceArray[i]));
            xmlSensorValues.getXmlSensorValue().add(xmlSensorValue);
        }
        xmlTransition.setXmlSensorValues(xmlSensorValues);
    }

    private static void outputSensorDescritions(XmlStateMachines xmlStateMachines, ActorTypeInterface actorTypeInterface) {
        SensorTypeInterface[] sensorTypeInterfaceArray = actorTypeInterface.getSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            XmlSensorDefinition xmlSensorDefinition = new XmlSensorDefinition();
            xmlSensorDefinition.setDescription(sensorTypeInterfaceArray[i].getDescription());
            xmlSensorDefinition.setIdentifier(sensorTypeInterfaceArray[i].getIdentifier());
            xmlSensorDefinition.setName(sensorTypeInterfaceArray[i].getName());
            xmlSensorDefinition.setParameterString((String)sensorTypeInterfaceArray[i].getAttribute("paramString"));
            xmlStateMachines.getXmlSensorDefinition().add(xmlSensorDefinition);
        }
    }
}

