/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItem;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.StateRowItemModel;
import ch.karatojava.util.gui.rieditor.DefaultRow;
import ch.karatojava.util.gui.rieditor.ItemInterface;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowItemModelInterface;

public class TransitionRow
extends DefaultRow
implements RowInterface {
    protected UpdateState updateState;
    protected Transition transition;

    public TransitionRow(StateRowItemModel stateRowItemModel, Transition transition, UpdateState updateState) {
        super(stateRowItemModel);
        this.transition = transition;
        this.updateState = updateState;
        updateState.setDataModelState(true);
        CommandTypeInterface[] commandTypeInterfaceArray = transition.getCommands();
        for (int i = 0; i < commandTypeInterfaceArray.length; ++i) {
            this.addItem(new CommandItem(commandTypeInterfaceArray[i], this));
        }
        updateState.setDataModelState(false);
    }

    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public void addItem(ItemInterface itemInterface, int n) {
        super.addItem(itemInterface, n);
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            CommandItem commandItem = (CommandItem)itemInterface;
            this.transition.addCommand(commandItem.getCommand(), n);
            this.updateState.setViewModelState(false);
        }
    }

    @Override
    public void removeItem(ItemInterface itemInterface) {
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            this.transition.removeCommand(this.indexOf(itemInterface));
            this.updateState.setViewModelState(false);
        }
        super.removeItem(itemInterface);
    }

    @Override
    public RowInterface createCopy(RowItemModelInterface rowItemModelInterface) {
        StateRowItemModel stateRowItemModel = (StateRowItemModel)rowItemModelInterface;
        State state = stateRowItemModel.getState();
        Transition transition = new Transition(state, this.transition.getTo());
        transition.setCommands(this.transition.getCommands());
        SensorTypeInterface[] sensorTypeInterfaceArray = state.getSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            if (!this.transition.getFrom().usesSensor(sensorTypeInterfaceArray[i])) continue;
            transition.setSensorInput(sensorTypeInterfaceArray[i], this.transition.getSensorInput(sensorTypeInterfaceArray[i]));
        }
        return new TransitionRow(stateRowItemModel, transition, this.updateState);
    }
}

