/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandException;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.karaide.KaraActorType;
import ch.karatojava.util.GuiFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;

public class KaraActor
implements ActorInterface {
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected static final Class[] NO_PARAMS = new Class[0];
    protected KaraActorType karaActorType;
    protected Kara kara;
    protected int integerIdentifier;
    protected String identity;

    public KaraActor(KaraActorType karaActorType, String string, int n) {
        this.karaActorType = karaActorType;
        this.identity = string;
        this.integerIdentifier = n;
    }

    @Override
    public ActorTypeInterface getActorType() {
        return this.karaActorType;
    }

    @Override
    public void execute(CommandTypeInterface commandTypeInterface) throws CommandException {
        try {
            Method method = KaraActorKonfig.getInstance().getKaraActorClass().getMethod(commandTypeInterface.getName(), NO_PARAMS);
            method.invoke((Object)this.kara, NO_ARGUMENTS);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandException(commandTypeInterface, illegalAccessException, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CommandException(commandTypeInterface, (Exception)invocationTargetException.getTargetException(), this);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CommandException(commandTypeInterface, noSuchMethodException, this);
        }
    }

    @Override
    public boolean getValue(SensorTypeInterface sensorTypeInterface) {
        boolean bl = sensorTypeInterface.evaluate(this.kara);
        return bl;
    }

    @Override
    public ImageIcon getIcon() {
        ImageIcon imageIcon = GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/" + this.identity + "/east");
        return imageIcon;
    }

    public void setKara(Kara kara) {
        this.kara = kara;
    }

    public Kara getKara() {
        return this.kara;
    }

    public void resetKara() {
        this.kara = null;
    }

    public int getActorIntegerIdentifier() {
        return this.integerIdentifier;
    }

    @Override
    public String getName() {
        return this.identity;
    }
}

