/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class KaraActorCommandsToolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected int MAX_COMMANDS_PER_COLUMN = 6;
    protected WorldEditor worldEditor;
    protected String karaIdentity;
    protected JPanel commandPanel;
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected static final Class[] NO_PARAMS = new Class[0];

    public KaraActorCommandsToolbar(WorldEditor worldEditor) {
        assert (worldEditor != null) : "KaraCommandsToolbar.constructor: worldEditor == null";
        this.worldEditor = worldEditor;
        this.createGUI();
        this.karaIdentity = Kara.getKaras()[0].getIdentity();
    }

    protected void createGUI() {
        String[] stringArray = KaraActorKonfig.getCommands();
        this.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/karacontroller/bordertitle"));
        this.commandPanel = new JPanel();
        this.commandPanel.setLayout(new BoxLayout(this.commandPanel, 1));
        this.commandPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        for (int i = 0; i < stringArray.length; ++i) {
            this.commandPanel.add(this.createButton(stringArray[i]));
        }
        this.add(this.commandPanel);
        this.add(Box.createVerticalGlue());
    }

    protected JButton createButton(String string) {
        String string2 = "schemes/ladybugscheme//commands/" + string;
        JButton jButton = new JButton(GuiFactory.getInstance().createImageIcon(string2));
        this.createButtonUi(jButton);
        jButton.addActionListener(new CommandActionListener(string));
        jButton.setAlignmentX(0.5f);
        String string3 = Configuration.getInstance().getString("language/$language/commands/$karamodel/" + string);
        jButton.setToolTipText(string3);
        return jButton;
    }

    protected void createButtonUi(JButton jButton) {
        GuiFactory.getInstance().createButtonUI(jButton);
    }

    protected class CommandActionListener
    extends ExceptionActionListener {
        private String commandName;

        public CommandActionListener(String string) {
            this.commandName = string;
        }

        @Override
        public void action(ActionEvent actionEvent) throws Exception {
            Kara kara;
            if (KaraActorCommandsToolbar.this.karaIdentity == null) {
                throw new KaraException("language/$language/kawomodel/karaexception/nokaraselected");
            }
            World world = KaraActorCommandsToolbar.this.worldEditor.getWorld();
            if (Kara.findKaraInWorld(world, (kara = Kara.getKara(KaraActorCommandsToolbar.this.karaIdentity)).getIdentity()) == null) {
                throw new KaraException("language/$language/kawomodel/karaexception/karanotinworld", new String[]{Configuration.getInstance().getString("schemes/ladybugscheme/" + kara.getIdentity() + "/description/$language")}, (Icon)kara.getClientProperty("imageicon"));
            }
            kara = Kara.findKaraInWorld(world, kara.getIdentity());
            try {
                Class clazz = KaraActorKonfig.getInstance().getKaraActorClass();
                Method method = clazz.getMethod(this.commandName, NO_PARAMS);
                method.invoke((Object)kara, NO_ARGUMENTS);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("could not create command object");
            }
        }
    }
}

