/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.kapps.actorfsm.SensorFactoryInterface;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActor;
import ch.karatojava.kapps.karaide.KaraActorType;
import ch.karatojava.util.Configuration;
import java.util.Hashtable;
import java.util.List;

public class KaraActorKonfig {
    private static KaraActorKonfig instance;
    private static KaraActorType karaActorType;
    protected KaraActor[] karaActors;
    protected Hashtable<String, KaraActor> karaActorIdentities;
    protected Hashtable<Integer, KaraActor> karaActorHashtable;
    private static Class karaActorClass;
    private SensorFactoryInterface sensorFactory;

    private KaraActorKonfig(KaraActorType karaActorType) {
        KaraActorKonfig.karaActorType = karaActorType;
        this.createKaraActors();
    }

    public KaraActorType getKaraActorType() {
        return karaActorType;
    }

    private void createKaraActors() {
        KaraActorType karaActorType = this.getKaraActorType();
        this.karaActorIdentities = new Hashtable();
        this.karaActorHashtable = new Hashtable();
        Kara[] karaArray = Kara.getKaras();
        this.karaActors = new KaraActor[karaArray.length];
        for (int i = 0; i < karaArray.length; ++i) {
            this.karaActors[i] = new KaraActor(karaActorType, karaArray[i].getIdentity(), karaArray[i].getIntegerIdentifier());
            this.karaActorIdentities.put(karaArray[i].getIdentity(), this.karaActors[i]);
            this.karaActorHashtable.put(new Integer(karaArray[i].getIntegerIdentifier()), this.karaActors[i]);
        }
    }

    public KaraActor[] getKaraActors() {
        return (KaraActor[])this.karaActors.clone();
    }

    public KaraActor getKaraActor(String string) {
        if (string == null) {
            return null;
        }
        return this.karaActorIdentities.get(string);
    }

    public KaraActor getActorByIntId(int n) {
        return this.karaActorHashtable.get(new Integer(n));
    }

    public Class getKaraActorClass() {
        return karaActorClass;
    }

    public static String[] getCommands() {
        String string = Configuration.getInstance().getString("karamodel/$karamodel/commands");
        List<String> list = Configuration.split(string, ",");
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    public static SensorFactoryInterface getSensorFactory() {
        assert (instance != null) : "Konfig.getSensorFactory: instance has not been created";
        return KaraActorKonfig.instance.sensorFactory;
    }

    public static void createInstance(KaraActorType karaActorType, SensorFactoryInterface sensorFactoryInterface) {
        assert (instance == null) : "KaraActorKonfig.createInstance: instance already created";
        instance = new KaraActorKonfig(karaActorType);
        KaraActorKonfig.instance.sensorFactory = sensorFactoryInterface;
        karaActorClass = karaActorType.getKaraActorClass();
    }

    public static KaraActorKonfig getInstance() {
        assert (instance != null) : "KaraActorKonfig.getInstance: instance is null";
        return instance;
    }
}

