/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.KaraInterpreterUiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.actorfsm.SingleActorFsmInterpreter;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.editor.FsmStatisticsWindow;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActor;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.world.World;
import ch.karatojava.util.Configuration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;

public class KaraInterpreterFacade
implements InterpreterFacadeInterface {
    protected static final String KARA_IDENTITY = Configuration.getInstance().getString("karamodel/$karamodel/karaidentities");
    protected KaraActor karaActor;
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected RunnableInterface interpreter;
    protected InterpreterToolbar toolbar;
    protected FsmStatisticsWindow fsmStatisticsWindow;
    protected ActionListener interpreterModeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KaraInterpreterFacade.this.karaFsmInterpreter.setDeterministic(actionEvent.getActionCommand().equals("deterministic"));
        }
    };
    protected ActionListener fsmStatisticsWindowListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KaraInterpreterFacade.this.fsmStatisticsWindow.setVisible(actionEvent.getActionCommand().equals("visible"));
        }
    };
    protected SingleActorFsmInterpreter karaFsmInterpreter = new SingleActorFsmInterpreter(){

        @Override
        public void getReady() throws InterpreterException {
            KaraInterpreterFacade.this.checkProgramEditorWindow();
            Hashtable hashtable = (Hashtable)KaraInterpreterFacade.this.programEditorFacade.getProgramEditor().getContent();
            StateMachine stateMachine = (StateMachine)hashtable.get(KaraInterpreterFacade.this.karaActor);
            assert (stateMachine != null) : "KaraInterpreterFacade.karaFsmInterpreter.getReady: stateMachine == null";
            this.setStateMachine(stateMachine);
            this.setActor(KaraInterpreterFacade.this.karaActor);
            World world = (World)KaraInterpreterFacade.this.worldEditorFacade.getWorldEditor().getContent();
            Kara kara = Kara.findKaraInWorld(world, KARA_IDENTITY);
            if (kara == null) {
                throw new InterpreterException(Configuration.getInstance().getString("language/$language/kawomodel/karaexception/nokarainworld"));
            }
            KaraActorKonfig.getInstance().getKaraActor(KARA_IDENTITY).setKara(kara);
            super.getReady();
        }
    };

    @Override
    public void setEditorFacades(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface) {
        this.worldEditorFacade = worldEditorFacadeInterface;
        this.programEditorFacade = programEditorFacadeInterface;
    }

    @Override
    public int getNumberOfInitSteps() {
        return 4;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        int n2;
        this.karaActor = KaraActorKonfig.getInstance().getKaraActor(KARA_IDENTITY);
        jLabel.setText("creating interpreter ...");
        this.interpreter = this.createInterpreter();
        jProgressBar.setValue(++n);
        jLabel.setText("creating interpreter toolbar  ...");
        this.toolbar = this.createToolbar(this.interpreter);
        jProgressBar.setValue(++n);
        jLabel.setText("hooking up interpreter listeners...");
        InterpreterListener[] interpreterListenerArray = this.worldEditorFacade.getInterpreterListeners();
        for (n2 = 0; n2 < interpreterListenerArray.length; ++n2) {
            this.getInterpreter().addInterpreterListener(interpreterListenerArray[n2]);
        }
        interpreterListenerArray = this.programEditorFacade.getInterpreterListeners();
        for (n2 = 0; n2 < interpreterListenerArray.length; ++n2) {
            this.getInterpreter().addInterpreterListener(interpreterListenerArray[n2]);
        }
        jProgressBar.setValue(++n);
        jLabel.setText("creating interpreter statistics window  ...");
        this.fsmStatisticsWindow = this.createFsmStatisticsWindow();
        jProgressBar.setValue(++n);
        return n;
    }

    protected void checkProgramEditorWindow() throws InterpreterException {
        if (!this.programEditorFacade.getProgramEditorGui().isVisible()) {
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/interpreter/progwinclosed"));
        }
    }

    protected RunnableInterface createInterpreter() {
        return new StepableInterpreter(this.karaFsmInterpreter);
    }

    protected InterpreterToolbar createToolbar(RunnableInterface runnableInterface) {
        return new InterpreterToolbar(new KaraInterpreterUiFactory(), runnableInterface);
    }

    protected FsmStatisticsWindow createFsmStatisticsWindow() {
        FsmStatisticsWindow fsmStatisticsWindow = new FsmStatisticsWindow();
        this.interpreter.addInterpreterListener(fsmStatisticsWindow.getInterpreterListener());
        return fsmStatisticsWindow;
    }

    @Override
    public JComponent getInterpreterToolbar() {
        return this.toolbar;
    }

    @Override
    public RunnableInterface getInterpreter() {
        return this.interpreter;
    }

    protected ActionListener getInterpreterModeListener() {
        return this.interpreterModeListener;
    }

    protected ActionListener getFsmStatisticsWindowListener() {
        return this.fsmStatisticsWindowListener;
    }

    @Override
    public JComponent getConfigGui() {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(karaGuiFactory.createConfigurableRadioButtonPanel(this.getInterpreterModeListener(), "determinism", "language/$language/karaconfigdialog/interpretermode"));
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = karaGuiFactory.createConfigurableRadioButtonPanel(this.getFsmStatisticsWindowListener(), "statistics", "language/$language/karaconfigdialog/statistics");
        jPanel.add(jPanel2);
        this.fsmStatisticsWindow.addWindowListener(new StatisticsWindowListener((List)jPanel2.getClientProperty("radiobuttonproperty")));
        return jPanel;
    }

    protected class StatisticsWindowListener
    extends WindowAdapter {
        List buttons;

        public StatisticsWindowListener(List list) {
            this.buttons = list;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                JRadioButton jRadioButton;
                jRadioButton.setSelected(!(jRadioButton = (JRadioButton)this.buttons.get(i)).isSelected());
            }
        }
    }
}

