/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorWindowListener;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditorUiFactory;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.StateDialog;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.karaide.KaraActorType;
import ch.karatojava.kapps.karaide.KaraSensorFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class KaraProgramEditorFacade
implements ProgramEditorFacadeInterface {
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected JFrame editorFrame;
    protected ActorFsmEditor fsmEditor;

    @Override
    public void setWorldEditorFacade(WorldEditorFacadeInterface worldEditorFacadeInterface) {
        this.worldEditorFacade = worldEditorFacadeInterface;
    }

    @Override
    public int getNumberOfInitSteps() {
        return 3;
    }

    @Override
    public JFrame getProgramEditorGui() {
        return this.editorFrame;
    }

    @Override
    public EditorIoToolbar getProgramEditorIoToolbar() {
        return this.fsmEditor.getEditorIoToolbar();
    }

    @Override
    public EditorInterface getProgramEditor() {
        return this.fsmEditor;
    }

    @Override
    public JComponent getConfigGui() {
        return null;
    }

    @Override
    public InterpreterListener[] getInterpreterListeners() {
        InterpreterListener[] interpreterListenerArray = this.fsmEditor.getInterpreterListeners();
        InterpreterListener[] interpreterListenerArray2 = new InterpreterListener[interpreterListenerArray.length + 1];
        System.arraycopy(interpreterListenerArray, 0, interpreterListenerArray2, 0, interpreterListenerArray.length);
        interpreterListenerArray2[interpreterListenerArray.length] = new KaraEditorUiFactory.InterpreterListener(this.fsmEditor.getEditorIoToolbar());
        return interpreterListenerArray2;
    }

    protected void createKaraActorKonfig() {
        KaraActorKonfig.createInstance(KaraActorType.getInstance(), new KaraSensorFactory());
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        this.createKaraActorKonfig();
        jLabel.setText("create empty editor frame...");
        this.editorFrame = KaraGuiFactory.getInstance().createProgramEditorFrame();
        jProgressBar.setValue(++n);
        jLabel.setText("actor state machine editor ...");
        this.fsmEditor = this.createActorFsmEditor(this.editorFrame);
        jProgressBar.setValue(++n);
        jLabel.setText("actor state machine editor frame ...");
        this.createProgramEditorGui(this.editorFrame, this.fsmEditor);
        jProgressBar.setValue(++n);
        return n;
    }

    protected void createProgramEditorGui(JFrame jFrame, ActorFsmEditor actorFsmEditor) {
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)actorFsmEditor.getGui(), "Center");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new EditorWindowListener(false, actorFsmEditor.getEditorIoToolbar(), null));
    }

    protected ActorFsmEditor createActorFsmEditor(JFrame jFrame) {
        this.fsmEditor = new ActorFsmEditor(new ActorFsmEditorUiFactory(), KaraActorKonfig.getInstance().getKaraActorType(), KaraActorKonfig.getInstance().getKaraActors(), this.createStateDialog(jFrame));
        return this.fsmEditor;
    }

    protected StateDialog createStateDialog(JFrame jFrame) {
        StateDialog stateDialog = new StateDialog((Frame)jFrame, "State editor", KaraActorKonfig.getInstance().getKaraActorType());
        return stateDialog;
    }
}

