/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.SchedulerListener;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActorCommandsToolbar;
import ch.karatojava.kapps.karaide.worldio.WorldBuilder;
import ch.karatojava.kapps.karaide.worldio.WorldOutputter;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.kapps.world.editor.WorldEditorToolbar;
import ch.karatojava.kapps.world.editor.WorldViewToolbar;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class KaraWorldEditorFacade
implements WorldEditorFacadeInterface {
    protected WorldEditor worldEditor;
    protected KaraActorCommandsToolbar karaCommandToolbar;
    protected WorldEditorToolbar worldEditorToolbar;
    protected WorldViewToolbar worldViewToolbar;
    protected EditorIoToolbar worldEditorIOToolbar;
    protected JComponent westPanel;
    protected JComponent eastPanel;

    @Override
    public int getNumberOfInitSteps() {
        return 7;
    }

    @Override
    public JComponent getWorldEditorGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.worldEditor.getWorldView(), "Center");
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/bordertitle"));
        return jPanel;
    }

    @Override
    public EditorInterface getWorldEditor() {
        return this.worldEditor;
    }

    @Override
    public JComponent getActorCommandToolbar() {
        return this.karaCommandToolbar;
    }

    @Override
    public JComponent getWestPanel() {
        return this.westPanel;
    }

    @Override
    public JComponent getWorldEditorToolbar() {
        return this.eastPanel != null ? this.eastPanel : this.worldEditorToolbar;
    }

    @Override
    public EditorIoToolbar getWorldEditorIoToolbar() {
        return this.worldEditorIOToolbar;
    }

    @Override
    public JComponent getConfigGui() {
        return null;
    }

    @Override
    public InterpreterListener[] getInterpreterListeners() {
        return new InterpreterListener[]{this.worldEditorToolbar.getInterpreterListener(), new KaraEditorUiFactory.InterpreterListener(this.worldEditorIOToolbar)};
    }

    @Override
    public SchedulerListener[] getSchedulerListeners() {
        return new SchedulerListener[0];
    }

    @Override
    public JComponent getNorthPanel() {
        return null;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        jLabel.setText("creating karas ...");
        this.createKaraPrototypes();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world objects ...");
        this.createWorldObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor ...");
        this.worldEditor = this.createWorldEditor();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor io toolbar  ...");
        this.worldEditorIOToolbar = this.createWorldEditorIOToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating kara toolbar  ...");
        this.karaCommandToolbar = this.createkaraCommandToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating world toolbar ...");
        this.worldEditorToolbar = this.createworldEditorToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        if (this.worldEditor.getWorldView().isKarasPerspectivePossible()) {
            this.worldViewToolbar = this.createWorldViewToolbar(this.worldEditor);
            this.eastPanel = this.createEastPanel(this.worldEditorToolbar, this.worldViewToolbar);
        }
        jLabel.setText("creating zoom toolbar  ...");
        this.westPanel = this.createWestPanel(this.worldEditor);
        jProgressBar.setValue(++n);
        return n;
    }

    protected void createWorldObjects() {
        String string = Configuration.getInstance().getString("karamodel/$karamodel/worldobjects");
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            ImageIcon imageIcon;
            int n = Integer.parseInt(list.get(i));
            if (n == 2) {
                Konfig.addWorldObject(LEAF.getInstance());
                imageIcon = Configuration.getInstance().getImageIcon(Konstants.TOGGLEOBJECTMOUSELISTENER_CURSORIMAGES[2]);
                Konfig.addWorldImage(LEAF.getInstance(), imageIcon);
                LEAF.getInstance().setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[2]);
                continue;
            }
            if (n == 4) {
                Konfig.addWorldObject(MUSHROOM.getInstance());
                imageIcon = Configuration.getInstance().getImageIcon(Konstants.TOGGLEOBJECTMOUSELISTENER_CURSORIMAGES[4]);
                Konfig.addWorldImage(MUSHROOM.getInstance(), imageIcon);
                MUSHROOM.getInstance().setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[4]);
                continue;
            }
            if (n != 1) continue;
            Konfig.addWorldObject(TREE.getInstance());
            imageIcon = Configuration.getInstance().getImageIcon(Konstants.TOGGLEOBJECTMOUSELISTENER_CURSORIMAGES[1]);
            Konfig.addWorldImage(TREE.getInstance(), imageIcon);
            TREE.getInstance().setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[1]);
        }
    }

    protected void createKaraPrototypes() {
        int n = 1;
        String string = Configuration.getInstance().getString("karamodel/$karamodel/karaidentities");
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            Kara kara = new Kara(string2, n);
            Kara.addKaraPrototype(kara);
            Konfig.addWorldObject(kara);
            ImageIcon imageIcon = Configuration.getInstance().getImageIcon("schemes/ladybugscheme/" + string2 + "/paintedicon");
            Konfig.addWorldImage(LEAF.getInstance(n), imageIcon);
            ImageIcon[] imageIconArray = kara.getKaraImageIcons();
            for (int j = 0; j < imageIconArray.length; ++j) {
                Konfig.addWorldImage(kara, imageIconArray[j]);
            }
            kara.setGUIID(kara.getGUIID() - kara.getDirection() - 3);
            ++n;
            kara.setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[8]);
        }
    }

    protected WorldEditor createWorldEditor() {
        WorldEditor worldEditor = new WorldEditor(WorldBuilder.getInstance(), WorldOutputter.getInstance());
        worldEditor.getWorldView().setKarasPerspectivePossible(true);
        return worldEditor;
    }

    protected EditorIoToolbar createWorldEditorIOToolbar(WorldEditor worldEditor) {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        return new EditorIoToolbar(worldEditor, karaGuiFactory.createEditorToolbar(karaGuiFactory.getFileChooser(), karaGuiFactory.getWorldFileFilter()), karaGuiFactory.getWorldFileFilter().getExtensions()[0]);
    }

    protected KaraActorCommandsToolbar createkaraCommandToolbar(WorldEditor worldEditor) {
        return new KaraActorCommandsToolbar(worldEditor);
    }

    protected JComponent createWestPanel(WorldEditor worldEditor) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.getActorCommandToolbar());
        jPanel.add(this.worldEditorToolbar.getSizePanel());
        jPanel.add(this.worldEditorToolbar.getZoomPanel());
        return jPanel;
    }

    protected JComponent createEastPanel(WorldEditorToolbar worldEditorToolbar, WorldViewToolbar worldViewToolbar) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(worldEditorToolbar);
        jPanel.add(worldViewToolbar);
        return jPanel;
    }

    protected WorldEditorToolbar createworldEditorToolbar(WorldEditor worldEditor) {
        return new WorldEditorToolbar(worldEditor);
    }

    protected WorldViewToolbar createWorldViewToolbar(WorldEditor worldEditor) {
        return new WorldViewToolbar(worldEditor);
    }
}

