/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.legokaraide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorListenerAdapter;
import ch.karatojava.editor.EditorWindowListener;
import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.legokaraide.LegoDownload;
import ch.karatojava.kapps.legokaraide.LegoSettingsEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LegoSettingsEditorGui
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_SETTINGS_PER_PANEL = 4;
    protected LegoSettingsEditor settings;
    protected JTabbedPane settingsPane;
    protected JFileChooser nqcPathChooser;
    protected JTextField nqcPathTextField;
    protected JEditorPane settingDescription;
    protected JScrollPane settingsDescriptionScrollpane;
    protected ItemListener comPortListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            LegoSettingsEditorGui.this.settings.setValue("NQC_COM_PORT", (String)itemEvent.getItem());
        }
    };
    protected EditorListenerAdapter editorListener = new EditorListenerAdapter(){

        @Override
        public void loadedContent(EditorInterface editorInterface) {
            this.newContent(editorInterface);
        }

        @Override
        public void newContent(EditorInterface editorInterface) {
            LegoSettingsEditorGui.this.getContentPane().remove(LegoSettingsEditorGui.this.settingsPane);
            LegoSettingsEditorGui.this.settingsPane = LegoSettingsEditorGui.this.createdTabbedPane();
            LegoSettingsEditorGui.this.getContentPane().add((Component)LegoSettingsEditorGui.this.settingsPane, 1);
            LegoSettingsEditorGui.this.settingDescription.setText("");
            LegoSettingsEditorGui.this.validate();
        }
    };
    public DocumentListener nqcPathListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LegoSettingsEditorGui.this.settings.setValue("NQC_PATH", LegoSettingsEditorGui.this.nqcPathTextField.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    };

    public LegoSettingsEditorGui(LegoSettingsEditor legoSettingsEditor) {
        super(Configuration.getInstance().getString("language/$language/legokara/settingseditor/frametitle"));
        KaraGuiFactory.getInstance().createKaraFrameUi(this, null);
        this.settings = legoSettingsEditor;
        legoSettingsEditor.addEditorListener(this.editorListener);
        this.nqcPathChooser = this.createFileChooser("exe", Configuration.getInstance().getString("language/$language/legokara/settingseditor/compiler"));
        String string = Configuration.getInstance().getString("language/$language/legokara/settingseditor/properties");
        EditorIoToolbar editorIoToolbar = new EditorIoToolbar(legoSettingsEditor, new KaraEditorUiFactory(this.createFileChooser("properties", string), new ExampleFileFilter("properties", string)), "properties");
        this.settingDescription = new JEditorPane();
        this.settingDescription.setOpaque(false);
        this.settingDescription.setEditable(false);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(editorIoToolbar);
        this.settingsPane = this.createdTabbedPane();
        container.add(this.settingsPane);
        this.settingsDescriptionScrollpane = new JScrollPane(this.settingDescription);
        container.add(this.settingsDescriptionScrollpane);
        this.settingsDescriptionScrollpane.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/legokara/hinttitle"));
        this.settingsDescriptionScrollpane.setVerticalScrollBarPolicy(20);
        this.settingsDescriptionScrollpane.setHorizontalScrollBarPolicy(31);
        this.settingsDescriptionScrollpane.setPreferredSize(new Dimension(300, 100));
        this.addWindowListener(new EditorWindowListener(false, editorIoToolbar, null));
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        KaraGuiFactory.positionFrame(this, 0.5f, 0.5f);
    }

    protected JFileChooser createFileChooser(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new ExampleFileFilter(string, string2));
        GuiFactory.getInstance().addUiSwitchListener(jFileChooser);
        return jFileChooser;
    }

    protected JTabbedPane createdTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(Configuration.getInstance().getString("language/$language/legokara/settingseditor/titles/nqc"), this.createBoxYLayoutPanel(new JPanel[]{this.createPathPanel("NQC_PATH"), this.createPortPanel("NQC_COM_PORT")}));
        jTabbedPane.add(Configuration.getInstance().getString("language/$language/legokara/settingseditor/titles/robomovements"), this.createBoxYLayoutPanel(new JPanel[]{this.createSliderPanel("TURN_TIME_LEFT"), this.createSliderPanel("TURN_TIME_RIGHT"), this.createSliderPanel("MOVE_TIME"), this.createSliderPanel("RCX_CHECK_WAIT_TIME")}));
        jTabbedPane.add(Configuration.getInstance().getString("language/$language/legokara/settingseditor/titles/rcxmovements"), this.createBoxYLayoutPanel(new JPanel[]{this.createSliderPanel("RCX_TURN_TIME_RIGHT_GO"), this.createSliderPanel("RCX_TURN_TIME_RIGHT_BACK"), this.createSliderPanel("RCX_TURN_TIME_LEFT_GO"), this.createSliderPanel("RCX_TURN_TIME_LEFT_BACK")}));
        jTabbedPane.add(Configuration.getInstance().getString("language/$language/legokara/settingseditor/titles/lightsensors"), this.createBoxYLayoutPanel(new JPanel[]{this.createSliderPanel("LIGHT_SENSITY_RCX"), this.createSliderPanel("LIGHT_SENSITY_RCX_MOVE"), this.createSliderPanel("LIGHT_SENSITY_GROUND")}));
        return jTabbedPane;
    }

    protected JPanel createBoxYLayoutPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 0, 5));
        for (int i = 0; i < jComponentArray.length; ++i) {
            jPanel.add(jComponentArray[i]);
        }
        return jPanel;
    }

    protected JPanel createSliderPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/legokara/settingseditor/titles/" + string));
        int n = this.settings.getValue(string);
        int n2 = Configuration.getInstance().getInt("karamodel/legokara/settings/min/" + string);
        int n3 = Configuration.getInstance().getInt("karamodel/legokara/settings/max/" + string);
        JSlider jSlider = new JSlider(0, n2, n3, n);
        jSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        hashtable.put(new Integer(n2), new JLabel("" + n2));
        hashtable.put(new Integer(n3), new JLabel("" + n3));
        jSlider.setLabelTable(hashtable);
        JTextField jTextField = new JTextField();
        jSlider.addChangeListener(new SettingsChangeListener(jTextField, string));
        jTextField.setPreferredSize(new Dimension(48, 24));
        jTextField.setEditable(false);
        jTextField.setText(this.settings.getStringValue(string));
        JButton jButton = new JButton(Configuration.getInstance().getString("language/$language/legokara/settingseditor/testbutton"));
        jButton.addActionListener(new TestAction(string));
        JButton jButton2 = GuiFactory.getInstance().createImageIconButton("icons/help");
        jButton2.addActionListener(new HelpAction(string));
        jPanel.add(jSlider);
        jPanel.add(jTextField);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected JPanel createPathPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/legokara/settingseditor/titles/" + string));
        this.nqcPathTextField = new JTextField();
        this.nqcPathTextField.setPreferredSize(new Dimension(300, 24));
        this.nqcPathTextField.setText(this.settings.getStringValue(string));
        this.nqcPathTextField.getDocument().addDocumentListener(this.nqcPathListener);
        JButton jButton = new JButton(Configuration.getInstance().getString("language/$language/legokara/settingseditor/browsebutton"));
        jButton.addActionListener(new ExceptionActionListener(this, "browseNqcPath"));
        jPanel.add(this.nqcPathTextField);
        jPanel.add(jButton);
        return jPanel;
    }

    public void browseNqcPath() {
        File file;
        int n = this.nqcPathChooser.showOpenDialog(this);
        if (n == 0 && (file = this.nqcPathChooser.getSelectedFile()) != null) {
            this.nqcPathTextField.setText(file.getPath());
            this.settings.setValue("NQC_PATH", file.getPath());
        }
    }

    protected JPanel createPortPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/legokara/settingseditor/titles/" + string));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("COM1");
        jComboBox.addItem("COM2");
        jComboBox.addItem("USB");
        jComboBox.addItemListener(this.comPortListener);
        jComboBox.setSelectedItem(this.settings.getStringValue("NQC_COM_PORT"));
        jComboBox.setPreferredSize(new Dimension(150, 24));
        jPanel.add(jComboBox);
        return jPanel;
    }

    protected class HelpAction
    extends ExceptionActionListener {
        protected String settingName;

        public HelpAction(String string) {
            this.settingName = string;
        }

        @Override
        public void action(ActionEvent actionEvent) throws Exception {
            LegoSettingsEditorGui.this.settingDescription.setText(Configuration.getInstance().getString("language/$language/legokara/settingseditor/descriptions/" + this.settingName));
        }
    }

    protected class TestAction
    extends ExceptionActionListener {
        protected String settingName;

        public TestAction(String string) {
            this.settingName = string;
        }

        @Override
        public void action(ActionEvent actionEvent) throws Exception {
            String string = LegoDownload.loadPredefinedProgram(this.settingName);
            LegoDownload.download(true, false, string);
        }
    }

    protected class SettingsChangeListener
    implements ChangeListener {
        protected JTextField textField;
        protected String settingName;

        public SettingsChangeListener(JTextField jTextField, String string) {
            this.textField = jTextField;
            this.settingName = string;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((JSlider)changeEvent.getSource()).getValue();
            this.textField.setText(Integer.toString(n));
            LegoSettingsEditorGui.this.settings.setValue(this.settingName, n);
        }
    }
}

