/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide;

import ch.karatojava.kapps.abstractturtleide.TurtleWrapper;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import java.awt.Color;

public class LogoTurtlePrimitives
extends PrimitiveGroup {
    private TurtleWrapper turtle;

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("BACK", "pBACK", 1);
        this.registerPrimitive("CLEAN", "pCLEAN", 0);
        this.registerPrimitive("DISTANCETO", "pDISTANCETO", 1);
        this.registerPrimitive("DISTANCETOXY", "pDISTANCETOXY", 2);
        this.registerPrimitive("FORWARD", "pFORWARD", 1);
        this.registerPrimitive("GETPENCOLOR", "pGETPENCOLOR", 0);
        this.registerPrimitive("HEADING", "pHEADING", 0);
        this.registerPrimitive("HIDETURTLE", "pHIDETURTLE", 0);
        this.registerPrimitive("HOME", "pHOME", 0);
        this.registerPrimitive("LEFT", "pLEFT", 1);
        this.registerPrimitive("PENDOWN", "pPENDOWN", 0);
        this.registerPrimitive("PENUP", "pPENUP", 0);
        this.registerPrimitive("POS", "pPOS", 0);
        this.registerPrimitive("RIGHT", "pRIGHT", 1);
        this.registerPrimitive("SETHEADING", "pSETHEADING", 1);
        this.registerPrimitive("SETPENCOLOR", "pSETPENCOLOR", 1);
        this.registerPrimitive("SETPOS", "pSETPOS", 1);
        this.registerPrimitive("SETX", "pSETX", 1);
        this.registerPrimitive("SETXY", "pSETXY", 2);
        this.registerPrimitive("SETY", "pSETY", 1);
        this.registerPrimitive("SHOWTURTLE", "pSHOWTURTLE", 0);
        this.registerPrimitive("TOWARDS", "pTOWARDS", 1);
        this.registerPrimitive("TOWARDSXY", "pTOWARDSXY", 2);
        this.registerPrimitive("XSIZE", "pXSIZE", 0);
        this.registerPrimitive("YSIZE", "pYSIZE", 0);
    }

    public void setTurtleWrapper(TurtleWrapper turtleWrapper) {
        this.turtle = turtleWrapper;
    }

    public final LogoObject pBACK(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = -logoObjectArray[0].toNumber();
        this.turtle.back((int)d);
        return LogoVoid.obj;
    }

    public final LogoObject pCLEAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        this.turtle.clearWorld();
        return LogoVoid.obj;
    }

    public final LogoObject pDISTANCETO(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        double d3 = this.turtle.getX();
        double d4 = this.turtle.getY();
        double d5 = Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
        return new LogoWord(d5);
    }

    public final LogoObject pDISTANCETOXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        double d = logoObjectArray[0].toNumber();
        double d2 = logoObjectArray[1].toNumber();
        double d3 = this.turtle.getX();
        double d4 = this.turtle.getY();
        double d5 = Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
        return new LogoWord(d5);
    }

    public final LogoObject pFORWARD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.turtle.forward((int)logoObjectArray[0].toNumber());
        return LogoVoid.obj;
    }

    public final LogoObject pGETPENCOLOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(this.turtle.getColorRed()), new LogoWord(this.turtle.getColorGreen()), new LogoWord(this.turtle.getColorBlue())};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pHEADING(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        double d = this.turtle.getDirection();
        return new LogoWord(d);
    }

    public final LogoObject pHIDETURTLE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return LogoVoid.obj;
    }

    public final LogoObject pHOME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        this.turtle.moveto(0.0, 0.0);
        this.turtle.setDirection(0.0);
        return LogoVoid.obj;
    }

    public final LogoObject pLEFT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.turtle.turn((int)logoObjectArray[0].toNumber());
        return LogoVoid.obj;
    }

    public final LogoObject pPENDOWN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        this.turtle.penDown();
        return LogoVoid.obj;
    }

    public final LogoObject pPENUP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        this.turtle.penUp();
        return LogoVoid.obj;
    }

    public final LogoObject pPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        double d = this.turtle.getX();
        double d2 = this.turtle.getY();
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(d), new LogoWord(d2)};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pRIGHT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.turtle.turn((int)logoObjectArray[0].toNumber());
        return LogoVoid.obj;
    }

    public final LogoObject pSETHEADING(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        this.turtle.setDirection((int)d);
        return LogoVoid.obj;
    }

    public final LogoObject pSETPENCOLOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        Color color = this.findColor(logoObjectArray[0]);
        this.turtle.setColor(color.getRed(), color.getGreen(), color.getBlue());
        return LogoVoid.obj;
    }

    public final LogoObject pSETPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        this.turtle.moveto((int)d, (int)d2);
        return LogoVoid.obj;
    }

    public final LogoObject pSETX(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        this.turtle.setX((int)d);
        return LogoVoid.obj;
    }

    public final LogoObject pSETXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        double d = logoObjectArray[0].toNumber();
        double d2 = logoObjectArray[1].toNumber();
        this.turtle.setPosition((int)d, (int)d2);
        return LogoVoid.obj;
    }

    public final LogoObject pSETY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        this.turtle.setY((int)d);
        return LogoVoid.obj;
    }

    public final LogoObject pSHOWTURTLE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return LogoVoid.obj;
    }

    public final LogoObject pTOWARDS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        double d3 = this.fixAngle(90.0 - Math.atan2(d2 - this.turtle.getY(), d - this.turtle.getX()) / Math.PI * 180.0);
        return new LogoWord(d3);
    }

    public final LogoObject pTOWARDSXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        double d = logoObjectArray[0].toNumber();
        double d2 = logoObjectArray[1].toNumber();
        double d3 = this.fixAngle(90.0 - Math.atan2(d2 - this.turtle.getY(), d - this.turtle.getX()) / Math.PI * 180.0);
        return new LogoWord(d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pXSIZE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        double d = 0.0;
        LogoTurtlePrimitives logoTurtlePrimitives = this;
        synchronized (logoTurtlePrimitives) {
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pYSIZE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        double d = 0.0;
        LogoTurtlePrimitives logoTurtlePrimitives = this;
        synchronized (logoTurtlePrimitives) {
        }
        return new LogoWord(d);
    }

    private final Color findColor(LogoObject logoObject) throws LanguageException {
        if (logoObject instanceof LogoWord) {
            Color color = null;
            if (color == null) {
                throw new LanguageException("Color not found");
            }
            return color;
        }
        if (logoObject.length() != 3) {
            throw new LanguageException("Three elements expected in color list");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = ((LogoList)logoObject).pickInPlace(0).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in red value of color list");
        }
        try {
            n2 = ((LogoList)logoObject).pickInPlace(1).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in green value of color list");
        }
        try {
            n3 = ((LogoList)logoObject).pickInPlace(2).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in blue value of color list");
        }
        if (n < 0 || n > 255) {
            throw new LanguageException("Bad color (red value out of range)");
        }
        if (n2 < 0 || n2 > 255) {
            throw new LanguageException("Bad color (green value out of range)");
        }
        if (n3 < 0 || n3 > 255) {
            throw new LanguageException("Bad color (blue value out of range)");
        }
        return new Color(n, n2, n3);
    }

    private final double fixAngle(double d) {
        if (d < 0.0) {
            return d + 360.0 * Math.floor(-d / 360.0) + 360.0;
        }
        return d - 360.0 * Math.floor(d / 360.0);
    }
}

