/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.app.CliNoPromptConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class StringReaderConsole
extends CliNoPromptConsole {
    private String runtimeErrorMessage;
    private BufferedReader bufferedReader;
    private StringReader stringReader;
    private boolean endOfString = true;

    @Override
    protected void setup() {
    }

    public void setup(String string) {
        this.stringReader = new StringReader(string);
        this.bufferedReader = new BufferedReader(this.stringReader, string.length());
        this.endOfString = false;
    }

    @Override
    public synchronized boolean eof() {
        return this.endOfString;
    }

    @Override
    public synchronized String getLine() {
        try {
            String string = this.bufferedReader.readLine();
            if (string == null) {
                this.endOfString = true;
            }
            return string;
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return "";
        }
    }

    @Override
    public synchronized String promptGetLine(char c) {
        return this.getLine();
    }

    @Override
    public synchronized int getAvailable(char[] cArray) throws LanguageException {
        try {
            int n;
            for (n = 0; this.bufferedReader.ready() && n < cArray.length; ++n) {
                cArray[n] = (char)this.bufferedReader.read();
            }
            return n;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char c) {
        System.out.print(c);
        System.out.flush();
    }

    @Override
    public synchronized void put(String string) {
        System.out.print(string);
        System.out.flush();
    }

    @Override
    public synchronized void put(char[] cArray, int n) {
        System.out.print(new String(cArray, 0, n));
        System.out.flush();
    }

    @Override
    public synchronized void putLine(String string) {
        System.out.println(string);
    }

    @Override
    public synchronized char getChar() {
        try {
            return (char)this.bufferedReader.read();
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return '\u0000';
        }
    }

    @Override
    public synchronized boolean charAvail() {
        try {
            return this.bufferedReader.ready();
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return false;
        }
    }

    @Override
    public synchronized void createEditor(String string) throws LanguageException {
        throw new LanguageException("Editor not available");
    }

    @Override
    public void run() {
        Tokenizer tokenizer = new Tokenizer(this._mach.getTokenizerCommentFlags());
        boolean bl = false;
        this.runtimeErrorMessage = null;
        while (!bl) {
            try {
                if (this.eof()) break;
                LogoList logoList = null;
                LanguageException languageException = null;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 63;
                while (logoList == null && !this.eof()) {
                    String string = this.promptGetLine((char)n);
                    if (string == null) {
                        bl = true;
                        if (languageException == null) continue;
                        throw languageException;
                    }
                    try {
                        stringBuffer.append(string);
                        if (stringBuffer.length() == 0) {
                            logoList = new LogoList();
                            continue;
                        }
                        if (stringBuffer.charAt(stringBuffer.length() - 1) == '~') {
                            stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
                            n = 126;
                            continue;
                        }
                        logoList = tokenizer.tokenize(stringBuffer.toString());
                    }
                    catch (LanguageException languageException2) {
                        languageException = languageException2;
                        n = languageException2.getContChar();
                        if (n == 124 || n == 92 || n == 126) {
                            stringBuffer.append(Machine.LINE_SEPARATOR);
                            continue;
                        }
                        throw languageException2;
                    }
                }
                if (logoList == null || logoList.length() <= 0) continue;
                this._mach.spawnMainThread(logoList);
                this._mach.waitForAllTerminated();
                this.runtimeErrorMessage = this._mach.getRuntimeErrorMessage();
            }
            catch (LanguageException languageException) {
                this.runtimeErrorMessage = languageException.generateMessage();
                this.putLine(languageException.generateMessage());
            }
        }
    }

    public String getRuntimeErrorMessage() {
        return this.runtimeErrorMessage;
    }
}

