/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IORandom;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IORandomFile
implements IORandom {
    private static LogoObject _kind = new LogoWord("RANDOMFILE");
    private LogoObject _name;
    private RandomAccessFile _file;

    public IORandomFile(File file) throws LanguageException {
        try {
            this._name = new LogoWord(file.getPath());
            this._file = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new LanguageException("Couldn't open file: \"" + file.getPath() + "\" I/O: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new LanguageException("Couldn't open file: \"" + file.getPath() + "\" Security: " + securityException.toString());
        }
    }

    @Override
    public synchronized void close() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream already closed");
        }
        try {
            this._file.close();
            this._file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean isOpen() {
        return this._file != null;
    }

    @Override
    public synchronized LogoObject name() {
        return this._name;
    }

    @Override
    public synchronized LogoObject kind() {
        return _kind;
    }

    @Override
    public synchronized boolean eof() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            return this._file.getFilePointer() >= this._file.length();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized String getLine() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            int n;
            String string = this._file.readLine();
            if (string == null) {
                string = "";
            }
            if ((n = string.length()) > 0 && string.charAt(n - 1) == '\r') {
                string = string.substring(0, n - 1);
            } else if (n > 0 && string.charAt(n - 1) == '\n') {
                string = n > 1 && string.charAt(n - 2) == '\r' ? string.substring(0, n - 2) : string.substring(0, n - 1);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized int getAvailable(char[] cArray) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            byte[] byArray = new byte[cArray.length];
            int n = this._file.read(byArray);
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)(byArray[i] & 0xFF);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized char getChar() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            int n = this._file.read();
            return n == -1 ? (char)'\u0000' : (char)n;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized boolean charAvail() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            return this._file.getFilePointer() < this._file.length();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(String string) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            this._file.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void putLine(String string) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            this._file.writeBytes(string);
            this._file.writeBytes(Machine.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char c) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            this._file.writeByte((byte)c);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char[] cArray, int n) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            this._file.writeBytes(new String(cArray, 0, n));
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void flush() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
    }

    @Override
    public synchronized void seek(long l) throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            this._file.seek(l);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized long tell() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            return this._file.getFilePointer();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized long length() throws LanguageException {
        if (this._file == null) {
            throw new LanguageException("Stream is closed");
        }
        try {
            return this._file.length();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }
}

