/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOBase;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;

public class IOStream
implements IOBase {
    private LogoObject _name;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private static LogoObject _kind = new LogoWord("UNKNOWN");

    public IOStream() {
        this._name = LogoVoid.obj;
        this._reader = null;
        this._writer = null;
    }

    public IOStream(BufferedReader bufferedReader) {
        this._name = new LogoWord();
        this._reader = bufferedReader;
        this._writer = null;
    }

    public IOStream(BufferedWriter bufferedWriter) {
        this._name = new LogoWord();
        this._reader = null;
        this._writer = bufferedWriter;
    }

    public void open(LogoObject logoObject, BufferedReader bufferedReader) {
        this._name = logoObject;
        this._reader = bufferedReader;
        this._writer = null;
    }

    public void open(LogoObject logoObject, BufferedWriter bufferedWriter) {
        this._name = logoObject;
        this._reader = null;
        this._writer = bufferedWriter;
    }

    public void open(LogoObject logoObject, BufferedReader bufferedReader, BufferedWriter bufferedWriter) {
        this._name = logoObject;
        this._reader = bufferedReader;
        this._writer = bufferedWriter;
    }

    @Override
    public synchronized void close() throws LanguageException {
        if (this._writer == null && this._reader == null) {
            throw new LanguageException("Stream already closed");
        }
        try {
            if (this._writer != null) {
                this._writer.close();
            }
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._writer = null;
        this._reader = null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this._writer != null || this._reader != null;
    }

    @Override
    public synchronized LogoObject name() {
        return this._name;
    }

    @Override
    public synchronized LogoObject kind() {
        return _kind;
    }

    @Override
    public synchronized boolean eof() throws LanguageException {
        if (this._reader == null) {
            if (this._writer == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't read from " + this._name.toString());
        }
        try {
            this._reader.mark(2);
            int n = this._reader.read();
            if (n == -1) {
                return true;
            }
            this._reader.reset();
        }
        catch (IOException iOException) {
            return true;
        }
        return false;
    }

    @Override
    public synchronized String getLine() throws LanguageException {
        if (this._reader == null) {
            if (this._writer == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't read from " + this._name.toString());
        }
        try {
            String string = this._reader.readLine();
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized int getAvailable(char[] cArray) throws LanguageException {
        if (this._reader == null) {
            if (this._writer == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't read from " + this._name.toString());
        }
        try {
            int n;
            for (n = 0; this._reader.ready() && n < cArray.length; ++n) {
                cArray[n] = (char)this._reader.read();
            }
            return n;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized char getChar() throws LanguageException {
        if (this._reader == null) {
            if (this._writer == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't read from " + this._name.toString());
        }
        try {
            return (char)this._reader.read();
        }
        catch (EOFException eOFException) {
            return '\u0000';
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized boolean charAvail() throws LanguageException {
        if (this._reader == null) {
            if (this._writer == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't read from " + this._name.toString());
        }
        try {
            return this._reader.ready();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(String string) throws LanguageException {
        if (this._writer == null) {
            if (this._reader == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't write to " + this._name.toString());
        }
        try {
            this._writer.write(string);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void putLine(String string) throws LanguageException {
        if (this._writer == null) {
            if (this._reader == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't write to " + this._name.toString());
        }
        try {
            this._writer.write(string);
            this._writer.newLine();
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char c) throws LanguageException {
        if (this._writer == null) {
            if (this._reader == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't write to " + this._name.toString());
        }
        try {
            this._writer.write(c);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char[] cArray, int n) throws LanguageException {
        if (this._writer == null) {
            if (this._reader == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't write to " + this._name.toString());
        }
        try {
            this._writer.write(cArray, 0, n);
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void flush() throws LanguageException {
        if (this._writer == null) {
            if (this._reader == null) {
                throw new LanguageException("Stream is closed");
            }
            throw new LanguageException("Can't write to " + this._name.toString());
        }
        try {
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }
}

